package com.ejianc.business.finance.service.impl;

import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("loadBack")
public class LoadBackBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	// 是否推送凭证
	private static final String VOUCHER_PARAM = "P-h5UC6769";

	@Autowired
	private IParamConfigApi paramConfigApi;
	@Autowired
	private ILoadBackService loadBackService;
	@Autowired
	private IVoucherApi voucherApi;

	@Autowired
	private HttpServletRequest request;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LoadBackEntity entity = loadBackService.selectById(billId);
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
		if (byCode.isSuccess() && null != byCode.getData()) {
			ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
			String valueData = paramRegisterSetVO.getValueData();
			Long projectId = entity.getProjectId();
			if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
				ExecutorService threadPool = Executors.newFixedThreadPool(1);
				String authority = request.getHeader("authority");
				if (authority == null) {
					logger.info("request-authority为空");
					authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
				}
				try {
					VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200629000000003", entity, SystemCodeEnum.FINANCE);
					Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, loadBackService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);

					threadPool.submit(voucherCallable);
				} catch (Exception e) {
					logger.error("备用金退还推送凭证异常, ", e);
				} finally {
					threadPool.shutdown();
				}

			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LoadBackEntity entity = loadBackService.selectById(billId);
		//更新凭证恢复到初始态
		if (!VoucherFlag.NO_NEED.equals(entity.getVoucherFlag())) {
			//有凭证则删除
			ExecutorService threadPool = Executors.newFixedThreadPool(1);
			String authority = request.getHeader("authority");
			if (authority == null) {
				logger.info("request-authority为空");
				authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
			}
			try {
				VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200629000000003", entity, SystemCodeEnum.FINANCE);
				Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, loadBackService, voucherParams, VoucherOptFlag.DEL, RequestContextHolder.getRequestAttributes(), authority);
				threadPool.submit(voucherCallable);
			} catch (Exception e) {
				logger.error("备用金退还撤回凭证异常, ", e);
			} finally {
				threadPool.shutdown();
			}
		}
		return CommonResponse.success();
	}

}
