package com.ejianc.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.entity.TemplateEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.service.ITemplateCategoryService;
import com.ejianc.service.ITemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author:刘家乐
 * @version: 1
 * @document:
 */

@Api(tags = "模板管理-封装写法")
@RestController
@RequestMapping("template")
public class TemplateController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**此处需要根据实际修改*/
    private static final String BILL_CODE = "LJL_TEMPLATE";

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private ITemplateService templateService;

    @Autowired
    private ITemplateCategoryService categoryService;

    /**
     * 查询接口
     * @param params 查询参数
     * @return 返回分页数据
     */
    @ApiOperation(value = "分页查询模板列表（封装写法）")
    @RequestMapping(value = "/queryPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemplateEntity>> queryPage(@RequestBody Map<String, Object> params){
        // 从Map中获取分页参数
        long current = Long.parseLong(params.get("pageIndex").toString());
        long size = Long.parseLong(params.get("pageSize").toString());

        // 创建分页对象
        Page<TemplateEntity> page = new Page<>(current, size);

        // 创建查询条件
        LambdaQueryWrapper<TemplateEntity> queryWrapper = new LambdaQueryWrapper<>();

        // 根据Map中的参数添加查询条件
        if (params.containsKey("templateName") && StringUtils.isNotEmpty((String) params.get("templateName"))) {
            queryWrapper.like(TemplateEntity::getTemplateName, params.get("templateName"));
        }

        if (params.containsKey("categoryId") && params.get("categoryId") != null) {
            queryWrapper.eq(TemplateEntity::getCategoryId, params.get("categoryId"));
        }

        if (params.containsKey("enableStatus") && params.get("enableStatus") != null) {
            queryWrapper.eq(TemplateEntity::getEnableStatus, params.get("enableStatus"));
        }

        if (params.containsKey("fileType") && StringUtils.isNotEmpty((String) params.get("fileType"))) {
            queryWrapper.eq(TemplateEntity::getFileType, params.get("fileType"));
        }

        // 添加排序条件
        queryWrapper.orderByDesc(TemplateEntity::getCreateTime);

        // 执行分页查询
        IPage<TemplateEntity> result = templateService.page(page, queryWrapper);

        return CommonResponse.success("查询列表数据成功！", result);
    }


//    @GetMapping(value = "/detail")
//    @ResponseBody
//    public CommonResponse<TemplateVO> detailById(@RequestParam Long id) {
//        return CommonResponse.success(BeanMapper.map(service.selectById(id), TemplateVO.class));
//
//    }



}
