/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.entity.TemplateEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.service.ITemplateCategoryService;
import com.ejianc.service.ITemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6a21\u677f\u7ba1\u7406-\u5c01\u88c5\u5199\u6cd5"})
@RestController
@RequestMapping(value={"template"})
public class TemplateController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "LJL_TEMPLATE";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private ITemplateCategoryService categoryService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6a21\u677f\u5217\u8868\uff08\u5c01\u88c5\u5199\u6cd5\uff09")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateEntity>> queryPage(@RequestBody Map<String, Object> params) {
        long current = Long.parseLong(params.get("pageIndex").toString());
        long size = Long.parseLong(params.get("pageSize").toString());
        Page page = new Page(current, size);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (params.containsKey("templateName") && StringUtils.isNotEmpty((String)((String)params.get("templateName")))) {
            queryWrapper.like(TemplateEntity::getTemplateName, params.get("templateName"));
        }
        if (params.containsKey("categoryId") && params.get("categoryId") != null) {
            queryWrapper.eq(TemplateEntity::getCategoryId, params.get("categoryId"));
        }
        if (params.containsKey("enableStatus") && params.get("enableStatus") != null) {
            queryWrapper.eq(TemplateEntity::getEnableStatus, params.get("enableStatus"));
        }
        if (params.containsKey("fileType") && StringUtils.isNotEmpty((String)((String)params.get("fileType")))) {
            queryWrapper.eq(TemplateEntity::getFileType, params.get("fileType"));
        }
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        IPage result = this.templateService.page((IPage)page, (Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }
}

