package com.ejianc.controller;

import com.ejianc.entity.DataTagFillEntity;
import com.ejianc.entity.Result;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.util.GetDirPathUtil;
import com.ejianc.util.RemoteCallUtil;
import com.zhuozhengsoft.pageoffice.FileSaver;
import com.zhuozhengsoft.pageoffice.OpenModeType;
import com.zhuozhengsoft.pageoffice.PageOfficeCtrl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

@RestController
@RequestMapping(value = "/dataTagFill")
public class DocumentController {


    //获取doc目录的磁盘路径
    @Value("${dir}")
    private String dir;

    @Value("${dircopy}")
    private String dircopy;
    @Autowired
    private IAttachmentApi attachmentApi;


    @RequestMapping(value = "/editFile", method = org.springframework.web.bind.annotation.RequestMethod.POST)
    public String openFile(HttpServletRequest request, @RequestBody DataTagFillEntity dataTagFillEntity)  {
        PageOfficeCtrl poCtrl = new PageOfficeCtrl(request);

        String fileType = dataTagFillEntity.getFileType();
        String fileName = dataTagFillEntity.getFileName();

        poCtrl.webOpen("file://" + GetDirPathUtil.getDirPath() + fileName, OpenModeType.docNormalEdit, "Luna");

        try {
            // 准备请求数据
            String url = "http://localhost:8080/dataTagfill/fill";
            Map<String, String> headers = new HashMap<>();

            Result<Long> result = RemoteCallUtil.doPost(url, dataTagFillEntity, headers, Long.class);
            if (result.isSuccess()) {
                return poCtrl.getHtml();
        } else {
            throw new RuntimeException("编辑文件失败: " + result.getMsg());
        }

        } catch (RemoteCallUtil.RemoteCallException e) {
            e.printStackTrace();
        }
        return poCtrl.getHtml();
    }

    @RequestMapping(value = "/openFile",method = org.springframework.web.bind.annotation.RequestMethod.GET)
    @ResponseBody
    public void saveFile(@RequestParam String fileName) throws IOException {

        CommonResponse<AttachmentVO> attachmentVOCommonResponse = attachmentApi.queryDetail("1111222");

        Path path = Paths.get("C:\\Users\\fc\\IdeaProjects\\pageoffice6-vue3-springboot2\\pageoffice6-springboot2-back\\src\\main\\resources\\static\\doc\\DataTagEdit\\设备采购合同示范文本（通用带安装）_版本号20240725.docx");
        byte[] fileBytes = Files.readAllBytes(path);
        System.out.println(fileBytes);

        // 将 byte[] 转为 Base64 字符串
        String base64String = Base64.getEncoder().encodeToString(fileBytes);
        System.out.println(base64String);
        // 存入 List<String>
        List<String> stringList = new ArrayList<>();
        stringList.add(base64String);
        AttachmentRequestVO attachmentRequestVO = new AttachmentRequestVO();
        attachmentRequestVO.setBillType("BT211109000000002");
        attachmentRequestVO.setSourceId("1626042956941103106");
        attachmentRequestVO.setSourceType("template");
        attachmentRequestVO.setFileList(stringList);
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentRequestVO);
        List<AttachmentVO> data = listCommonResponse.getData();
        System.out.println(data);
    }

    @RequestMapping(value = "/saveFile1",method = RequestMethod.POST)
    public void saveFile1(HttpServletRequest request, HttpServletResponse response,@RequestParam String fileName) {
        FileSaver fs = new FileSaver(request, response);
//        fs.saveToFile(dircopy + fileName);
        fs.close();
    }
}



