/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.entity.TemplateEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.service.ITemplateCategoryService;
import com.ejianc.service.ITemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6a21\u677f\u7ba1\u7406-\u5c01\u88c5\u5199\u6cd5"})
@RestController
@RequestMapping(value={"template"})
public class TemplateController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "LJL_TEMPLATE";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private ITemplateCategoryService categoryService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6a21\u677f\u5217\u8868\uff08\u5c01\u88c5\u5199\u6cd5\uff09")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateEntity>> queryPage(@RequestBody Map<String, Object> params) {
        long current = Long.parseLong(params.get("pageIndex").toString());
        long size = Long.parseLong(params.get("pageSize").toString());
        Page page = new Page(current, size);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (params.containsKey("templateName") && StringUtils.isNotEmpty((String)((String)params.get("templateName")))) {
            queryWrapper.like(TemplateEntity::getTemplateName, params.get("templateName"));
        }
        if (params.containsKey("categoryId") && params.get("categoryId") != null) {
            queryWrapper.eq(TemplateEntity::getCategoryId, params.get("categoryId"));
        }
        if (params.containsKey("enableStatus") && params.get("enableStatus") != null) {
            queryWrapper.eq(TemplateEntity::getEnableStatus, params.get("enableStatus"));
        }
        if (params.containsKey("fileType") && StringUtils.isNotEmpty((String)((String)params.get("fileType")))) {
            queryWrapper.eq(TemplateEntity::getFileType, params.get("fileType"));
        }
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        IPage result = this.templateService.page((IPage)page, (Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @ApiOperation(value="\u590d\u6742\u67e5\u8be2\u6761\u4ef6\u7684\u539f\u751fMyBatis-Plus\u5199\u6cd5")
    @GetMapping(value={"/queryPageComplex"})
    @ResponseBody
    public CommonResponse<IPage<TemplateEntity>> queryPageComplex(@ApiParam(value="\u5f53\u524d\u9875", defaultValue="1") @RequestParam(defaultValue="1") long current, @ApiParam(value="\u6bcf\u9875\u5927\u5c0f", defaultValue="10") @RequestParam(defaultValue="10") long size, @ApiParam(value="\u6a21\u677f\u540d\u79f0\uff08\u6a21\u7cca\u67e5\u8be2\uff09") @RequestParam(required=false) String templateName, @ApiParam(value="\u5206\u7c7bID\uff08\u7cbe\u786e\u67e5\u8be2\uff09") @RequestParam(required=false) Long categoryId, @ApiParam(value="\u6587\u4ef6\u7c7b\u578b\u5217\u8868\uff08IN\u67e5\u8be2\uff09") @RequestParam(required=false) String[] fileTypes, @ApiParam(value="\u6700\u5c0f\u6587\u4ef6\u5927\u5c0f") @RequestParam(required=false) Integer minFileSize, @ApiParam(value="\u6700\u5927\u6587\u4ef6\u5927\u5c0f") @RequestParam(required=false) Integer maxFileSize) {
        Page page = new Page(current, size);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((String)templateName)) {
            queryWrapper.like(TemplateEntity::getTemplateName, (Object)templateName);
        }
        if (categoryId != null) {
            queryWrapper.eq(TemplateEntity::getCategoryId, (Object)categoryId);
        }
        if (fileTypes != null && fileTypes.length > 0) {
            queryWrapper.in(TemplateEntity::getFileType, (Object[])fileTypes);
        }
        if (minFileSize != null) {
            queryWrapper.ge(TemplateEntity::getFileSize, (Object)minFileSize);
        }
        if (maxFileSize != null) {
            queryWrapper.le(TemplateEntity::getFileSize, (Object)maxFileSize);
        }
        queryWrapper.eq(TemplateEntity::getEnableStatus, (Object)1);
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(BaseEntity::getCreateTime)).orderByAsc(TemplateEntity::getSequence);
        IPage result = this.templateService.page((IPage)page, (Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @ApiOperation(value="\u4f7f\u7528\u539f\u751fMyBatis-Plus\u7684selectMaps\u65b9\u6cd5\u8fdb\u884c\u7edf\u8ba1\u67e5\u8be2")
    @GetMapping(value={"/statistics"})
    @ResponseBody
    public CommonResponse<Map<String, Object>> getStatistics() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        long totalCount = this.templateService.count((Wrapper)queryWrapper);
        queryWrapper.select(new SFunction[]{TemplateEntity::getFileType, BaseEntity::getId});
        queryWrapper.groupBy((Object[])new SFunction[]{TemplateEntity::getFileType});
        LambdaQueryWrapper enabledWrapper = new LambdaQueryWrapper();
        enabledWrapper.eq(TemplateEntity::getEnableStatus, (Object)1);
        long enabledCount = this.templateService.count((Wrapper)enabledWrapper);
        HashMap<String, Long> statistics = new HashMap<String, Long>();
        statistics.put("totalCount", totalCount);
        statistics.put("enabledCount", enabledCount);
        statistics.put("disabledCount", totalCount - enabledCount);
        return CommonResponse.success((String)"\u7edf\u8ba1\u67e5\u8be2\u6210\u529f\uff01", statistics);
    }
}

