package com.ejianc.controller;

import com.ejianc.entity.UpLoad;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.zhuozhengsoft.pageoffice.FileSaver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

@RestController
@RequestMapping(value = "/upload")
public class UploadFileController {

    private static final Logger logger = LoggerFactory.getLogger(UploadFileController.class);

    @Autowired
    private IAttachmentApi attachmentApi;

    @PostMapping(value = "/uploadFile")
    public CommonResponse<List<AttachmentVO>> uploadFile(@RequestBody UpLoad UpLoad) throws IOException {
        logger.info("获取参数", UpLoad);
        String header = "data:application/docx;base64,";
        String base64String = UpLoad.getBase64String();
        String result= header + base64String;

        // 存入 List<String>
        List<String> stringList = new ArrayList<>();
        stringList.add(result);
        AttachmentRequestVO attachmentRequestVO = new AttachmentRequestVO();
        String billType = UpLoad.getBillType();
        String sourceId = UpLoad.getSourceId();
        String sourceType = UpLoad.getSourceType();
        //先删除已有的
        attachmentApi.deleteFileByParam(Long.valueOf(sourceId), billType, sourceType);

        attachmentRequestVO.setBillType(billType);
        attachmentRequestVO.setSourceId(sourceId);
        attachmentRequestVO.setSourceType(sourceType);
        attachmentRequestVO.setFileList(stringList);
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentRequestVO);
        return listCommonResponse;
    }

    @PostMapping(value = "/uploadFile2")
    public void uploadFile2( @RequestBody UpLoad UpLoad) throws IOException {
        Path path = Paths.get("C:\\Users\\fc\\IdeaProjects\\pageoffice6-springboot2-master\\target\\classes\\static\\doc\\DataTagEdit\\111111.docx");
        byte[] fileBytes = Files.readAllBytes(path);

        String header = "data:application/docx;base64,";

        // 将 byte[] 转为 Base64 字符串
        String base64String = Base64.getEncoder().encodeToString(fileBytes);
        String result= header + base64String;

        // 存入 List<String>
        List<String> stringList = new ArrayList<>();
        stringList.add(result);
        AttachmentRequestVO attachmentRequestVO = new AttachmentRequestVO();
        attachmentRequestVO.setBillType("BT220216000000003");
        attachmentRequestVO.setSourceId("1956275048645922818");
        attachmentRequestVO.setSourceType("subContractFile");
        attachmentRequestVO.setFileList(stringList);
        CommonResponse<String> stringCommonResponse = attachmentApi.deleteFileByParam(1956275048645922818L, "BT220216000000003", "subContractFile");
        System.out.println(stringCommonResponse);
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentRequestVO);
        List<AttachmentVO> data = listCommonResponse.getData();
        System.out.println(data);
    }

}



