/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.service.impl;

import com.ejianc.entity.TemplateEntity;
import com.ejianc.entity.UpLoad;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.service.ITemplateService;
import com.ejianc.service.IUploadFileService;
import com.ejianc.util.FileUtils;
import feign.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadFileServiceImpl
implements IUploadFileService {
    private static final Logger logger = LoggerFactory.getLogger(UploadFileServiceImpl.class);
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ITemplateService templateService;

    @Override
    public CommonResponse<List<AttachmentVO>> uploadFile(UpLoad upload) {
        logger.info("\u5f00\u59cb\u5904\u7406\u6587\u4ef6\u4e0a\u4f20\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}", (Object)upload.getBillType(), (Object)upload.getSourceId());
        try {
            String dataUri = FileUtils.buildDataUri(upload.getFileName(), upload.getBase64String());
            this.deleteExistingFiles(upload);
            CommonResponse<List<AttachmentVO>> response = this.uploadNewFile(upload, dataUri);
            if (response.isSuccess() && response.getData() != null) {
                List attachmentList = (List)response.getData();
                for (AttachmentVO attachment : attachmentList) {
                    attachment.setFileName(upload.getFileName());
                    this.attachmentApi.updateFileInfo(attachment);
                }
            }
            return response;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}", new Object[]{upload.getBillType(), upload.getSourceId(), e});
            return CommonResponse.error((String)("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Override
    public void uploadTemplate(UpLoad upload) throws IOException {
        logger.info("\u5f00\u59cb\u5904\u7406\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\uff0c\u6587\u4ef6ID: {}, \u6a21\u677f\u540d\u79f0: {}, \u6587\u4ef6\u540d: {}", new Object[]{upload.getFileId(), upload.getTemplateName(), upload.getFileName()});
        try {
            if (StringUtils.isBlank((String)upload.getFileName())) {
                throw new IOException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.uploadFileFromAttachment(upload.getFileId(), upload.getFileName());
            TemplateEntity templateEntity = this.createTemplateEntity(upload);
            this.templateService.save((Object)templateEntity);
            logger.info("\u6a21\u677f\u4fe1\u606f\u4fdd\u5b58\u6210\u529f: {}", (Object)templateEntity.getTemplateName());
        }
        catch (Exception e) {
            logger.error("\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6ID: {}", (Object)upload.getFileId(), (Object)e);
            throw new IOException("\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTemplate(UpLoad upload) throws IOException {
        logger.info("\u5f00\u59cb\u5904\u7406\u6a21\u677f\u5220\u9664\uff0c\u6587\u4ef6ID: {}, \u6a21\u677f\u540d\u79f0: {}", (Object)upload.getFileId(), (Object)upload.getFileName());
        try {
            this.callDeleteFileInterface(upload);
            String fileId = upload.getFileId();
            this.templateService.removeById((Serializable)((Object)fileId));
            logger.info("\u6a21\u677f\u5220\u9664\u6210\u529f\uff0c\u6587\u4ef6ID: {}", (Object)upload.getFileId());
        }
        catch (Exception e) {
            logger.error("\u6a21\u677f\u5220\u9664\u5931\u8d25\uff0c\u6587\u4ef6ID: {}", (Object)upload.getFileId(), (Object)e);
            throw new IOException("\u6a21\u677f\u5220\u9664\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void uploadFileFromAttachment(String fileId, String fileName) throws IOException {
        Response response = this.attachmentApi.downloadFileById(Long.valueOf(fileId));
        if (response == null || response.body() == null) {
            throw new IOException("\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6ID: " + fileId);
        }
        try (InputStream inputStream = response.body().asInputStream();){
            MultipartFile multipartFile = this.createMultipartFile(inputStream, fileName);
            this.callUploadFileInterface(multipartFile);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u6587\u4ef6\u540d: {}", (Object)fileName);
        }
    }

    @Override
    public void callUploadFileInterface(final MultipartFile multipartFile) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            ByteArrayResource fileResource = new ByteArrayResource(multipartFile.getBytes()){

                public String getFilename() {
                    return multipartFile.getOriginalFilename();
                }
            };
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"file", (Object)fileResource);
            HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            String uploadUrl = "http://10.136.208.154:8081/upload/uploadFile";
            ResponseEntity response = this.restTemplate.exchange(uploadUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u54cd\u5e94: {}", response.getBody());
            } else {
                logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void callDeleteFileInterface(UpLoad upload) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)upload, (MultiValueMap)headers);
            String deleteUrl = "http://10.136.208.154:8081/upload/deleteFile";
            ResponseEntity response = this.restTemplate.exchange(deleteUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                logger.error("\u8fdc\u7a0b\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff0c\u6587\u4ef6ID: {}, \u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", new Object[]{upload.getFileId(), response.getStatusCode(), response.getBody()});
                throw new RuntimeException("\u8fdc\u7a0b\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.getStatusCode());
            }
            logger.info("\u8fdc\u7a0b\u6587\u4ef6\u5220\u9664\u6210\u529f\uff0c\u6587\u4ef6ID: {}, \u54cd\u5e94: {}", (Object)upload.getFileId(), response.getBody());
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5220\u9664\u6587\u4ef6\u63a5\u53e3\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6ID: {}", (Object)upload.getFileId(), (Object)e);
            throw new RuntimeException("\u8c03\u7528\u5220\u9664\u6587\u4ef6\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void deleteExistingFiles(UpLoad upload) {
        try {
            Long sourceId = Long.valueOf(upload.getSourceId());
            this.attachmentApi.deleteFileByParam(sourceId, upload.getBillType(), upload.getSourceType());
            logger.debug("\u5df2\u5220\u9664\u5df2\u6709\u6587\u4ef6\uff0c\u6765\u6e90ID: {}", (Object)upload.getSourceId());
        }
        catch (NumberFormatException e) {
            logger.warn("\u6765\u6e90ID\u683c\u5f0f\u9519\u8bef\uff0c\u8df3\u8fc7\u5220\u9664\u64cd\u4f5c: {}", (Object)upload.getSourceId());
        }
        catch (Exception e) {
            logger.warn("\u5220\u9664\u5df2\u6709\u6587\u4ef6\u5931\u8d25\uff0c\u7ee7\u7eed\u4e0a\u4f20: {}", (Object)e.getMessage());
        }
    }

    private CommonResponse<List<AttachmentVO>> uploadNewFile(UpLoad upload, String dataUri) {
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(dataUri);
        AttachmentRequestVO request = new AttachmentRequestVO();
        request.setBillType(upload.getBillType());
        request.setSourceId(upload.getSourceId());
        request.setSourceType(upload.getSourceType());
        request.setFileList(fileList);
        CommonResponse response = this.attachmentApi.uploadForBase64(request);
        if (response.isSuccess()) {
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}, \u6587\u4ef6\u6570\u91cf: {}", new Object[]{upload.getBillType(), upload.getSourceId(), response.getData() != null ? ((List)response.getData()).size() : 0});
        } else {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{upload.getBillType(), upload.getSourceId(), response.getData()});
        }
        return response;
    }

    private MultipartFile createMultipartFile(InputStream inputStream, final String fileName) throws IOException {
        final byte[] fileBytes = this.readAllBytes(inputStream);
        return new MultipartFile(){

            public String getName() {
                return "file";
            }

            public String getOriginalFilename() {
                return fileName;
            }

            public String getContentType() {
                return FileUtils.getContentTypeByFileName(fileName);
            }

            public boolean isEmpty() {
                return fileBytes.length == 0;
            }

            public long getSize() {
                return fileBytes.length;
            }

            public byte[] getBytes() throws IOException {
                return fileBytes;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(fileBytes);
            }

            public void transferTo(File dest) throws IOException, IllegalStateException {
                Files.write(dest.toPath(), fileBytes, new OpenOption[0]);
            }
        };
    }

    private TemplateEntity createTemplateEntity(UpLoad upload) {
        TemplateEntity templateEntity = new TemplateEntity();
        templateEntity.setTemplateName(upload.getTemplateName());
        templateEntity.setCategoryName(upload.getCategoryName());
        templateEntity.setFileName(upload.getFileName());
        if (StringUtils.isNotBlank((String)upload.getFileId())) {
            templateEntity.setFileId(Long.valueOf(upload.getFileId()));
        }
        templateEntity.setEnableStatus(1);
        templateEntity.setSequence(1);
        templateEntity.setFileType(upload.getFileType());
        if (StringUtils.isNotBlank((String)upload.getBelongOrgName())) {
            templateEntity.setBelongOrgName(upload.getBelongOrgName());
        }
        logger.info("TemplateEntity\u521b\u5efa\u5b8c\u6210: \u6a21\u677f\u540d\u79f0={}, \u5206\u7c7b\u540d\u79f0={}, \u6240\u5c5e\u7ec4\u7ec7ID={}, \u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801={}, \u6587\u4ef6\u540d={}", new Object[]{templateEntity.getTemplateName(), templateEntity.getCategoryName(), templateEntity.getBelongOrgId(), templateEntity.getBelongOrgCode(), templateEntity.getFileName()});
        return templateEntity;
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

