package com.ejianc.business.proother.contract.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ChangeVO;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.util.ParamCtrlUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包变更实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("change")
public class ChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IChangeService service;

    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeVO> saveOrUpdate(@RequestBody ChangeVO saveorUpdateVO) {
        ChangeVO vo = service.insertOrUpdate(saveorUpdateVO, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetail(Long id) {
    	ChangeVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVO> vos) {

        if(CollectionUtils.isNotEmpty(vos)) {
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            List<ContractEntity>  contractEntityList = new ArrayList<>();
            for (ChangeVO ChangeVO : vos) {
                ChangeEntity changeEntity = service.selectById(ChangeVO.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(changeEntity, ChangeVO.class),"",changeEntity.getContractType(), false);
                totalExecutionVOList.add(executionVO.getTotalVO());
                contractEntityList.add(contractService.selectById(changeEntity.getContractId()));
            }
            logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
            //目标成本推送
            ContractVO tmp = null;
            for(ContractEntity contractEntity:contractEntityList) {
                tmp = BeanMapper.map(contractEntity, ContractVO.class);
                ExecutionVO executionVO = contractService.targetCost(tmp, getLinkUrl(tmp), contractEntity.getContractType());
                logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
                CommonResponse<String> responses = executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + responses.getMsg());
                }
            }
        }
        return service.deleteById(vos.get(0).getId());
    }

    public String getLinkUrl(ContractVO cv) {
        String linkUrl;
        // 是否是补充协议
        if (0 == cv.getSupplementFlag()){
            if (0 == cv.getAddType()){
                // 参照定标结果新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubCard";
            } else {
                // 直接新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubDirectCard";
            }
        } else {
            if (0 == cv.getAddType()){
                // 参照定标结果新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubCard";
            } else {
                // 直接新增
                linkUrl = BaseHost+"ejc-proother-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubDirectCard";
            }
        }
        return linkUrl;
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            return CommonResponse.error("查询失败，获取本下组织信息失败！");
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeEntity> page = service.queryPage(param,false);
        IPage<ChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description saveOrUpdate 查询当前合同下变更列表
     * @param id
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetailRecord(Long id) {
        ChangeVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更需要的主合同字段
     * @param contractId
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> addConvertByConId(Long contractId, Long changeId) {
        ChangeVO vo = service.addConvertByConId(contractId, changeId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Author yangst
     * @Description  查询变更对比
     * @param
     */
    @RequestMapping(value = "/queryChangeCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map returnMap = service.queryChangeCompare(id);
        return CommonResponse.success("新增转换数据成功！", returnMap);
    }

    /**
     * @Author yangst
     * @Description  查询变更记录
     * @param
     */
    @RequestMapping(value = "/queryChangeRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> queryChangeRecord(Long contractId, Long changeId) {
        ChangeVO vo = service.queryChangeRecord(contractId, changeId);
        return CommonResponse.success("变更记录查询成功！",vo);
    }

    /**
     * 变更合同签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/changeSignatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeSignatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ChangeEntity changeEntity = service.selectById(id);
        if (changeEntity != null){
            changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
            changeEntity.setEffectiveDate(new Date());
            changeEntity.setPerformanceStatus(ContractPerformanceStateEnum.履约中.getStateCode());
            changeEntity.setChangeFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            service.saveOrUpdate(changeEntity);

            //回写主合同（变更合同签章状态，主合同变更状态）
            LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
            updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.已变更.getCode());
            contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ChangeVO changeVO) {
        ChangeVO cv = service.insertOrUpdate(changeVO, true);
        String linkUrl = service.getLinkUrl(cv);
        ExecutionVO executionVO = service.targetCost(cv,linkUrl,cv.getContractType(), true);
        logger.error("目标成本推送控制：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());

            return response;
        }
        ParamsCheckVO responseData = paramCheck(changeVO, response, false);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        ChangeVO cv = service.queryDetail(id);
        String linkUrl = service.getLinkUrl(cv);
        //目标成本推送
        ExecutionVO executionVO = service.targetCost(cv, linkUrl, cv.getContractType(), false);
        logger.error("目标成本推送控制：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());

            return response;
        }
        ParamsCheckVO responseData = paramCheck(cv, response, true);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    /**
     * 其他支出合同变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     * 1、当该合同变更金额超过合同金额时，系统自动按设定方式控制；
     * 2、合同变更金额计算方式：变更单变更后的合同含税金额 - 合同变更前金额；contractTaxMny - baseTaxMny
     * 3、合同金额：最初始版本本合同金额；
     *
     * @param changeVO
     * @param flag 是否是新增的数据：true是，false否
     * @return
     */
    private ParamsCheckVO paramCheck(@RequestBody ChangeVO changeVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
        ParamsCheckVO responseData = response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();
        // 校验  其他支出合同-变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
        List<ParamsCheckVO> checkVOList = service.changeMnyCtrl(changeVO, flag);

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = checkVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }

        //如果目标成本预警登记小于等于参数控制预警登记
        if(null == responseData.getWarnType() || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(),1)) {
            for(ParamsCheckVO p : result) {
                resp.getDataSource().addAll(p.getDataSource());
            }
        } else if(ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(),1)) {
            if(CollectionUtils.isNotEmpty(responseData.getDataSource())) {
                resp.getDataSource().addAll(responseData.getDataSource());
            }
            for(ParamsCheckVO p : result) {
                resp.getDataSource().addAll(p.getDataSource());
            }
        } else { //否则
            return responseData;
        }


        return resp;
    }

}
