package com.ejianc.business.proother.relieve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.proother.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.proother.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.proother.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.relieve.vo.ContractRelieveVO;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.settle.bean.SettleEntity;
import com.ejianc.business.proother.settle.service.ISettleService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同解除实体
 *
 * @author generator
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService {
    @Autowired
    private IContractRelieveService service;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IContractService contractService;

    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    @Override
    public Boolean isCanRelieve(Long contractId) {
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        List<ContractRelieveEntity> list = service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost(ContractRelieveVO contractRelieveVO, String linkUrl){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractRelieveVO.getId());
        totalVO.setTenantId(contractRelieveVO.getTenantId());
        totalVO.setBillCode(contractRelieveVO.getBillCode());
        totalVO.setBillType("BT220317000000014");
        totalVO.setBussinessType(BussinessTypeEnum.其他支出合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractRelieveVO.getProjectId());
        totalVO.setOrgId(contractRelieveVO.getOrgId());

        // 推总金额执行表 【结算金额累计】 - 【合同金额】
        // 【结算金额累计】=所有已生效结算的【本期结算金额】累计值
        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;

        // 生效的单据状态
        ArrayList<Integer> list = new ArrayList<>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        // 查询生效的结算单累计值
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getDr, 0);
        wrapper.in(SettleEntity::getBillState, list);
        wrapper.eq(SettleEntity::getContractId, contractRelieveVO.getContractId());
        List<SettleEntity> settleList = settleService.list(wrapper);
        if (CollectionUtils.isNotEmpty(settleList)) {
            totalMny = settleList.stream().map(SettleEntity::getMny).reduce(totalMny, BigDecimal::add);
            totalTaxMny = settleList.stream().map(SettleEntity::getTaxMny).reduce(totalTaxMny, BigDecimal::add);
        }
        // 根据结算单的合同id查询合同详情
        ContractEntity contract = contractService.selectById(contractRelieveVO.getContractId());

        // 差额
        totalVO.setMoney(ComputeUtil.safeSub(totalMny, contract.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalTaxMny, contract.getContractTaxMny()));

        // LambdaQueryWrapper<SettleEntity> processQuery = new LambdaQueryWrapper<>();
        // processQuery.eq(SettleEntity::getContractId, contractVO.getId());
        // processQuery.in(SettleEntity::getBillState,1,3);
        // processQuery.eq(SettleEntity::getDr,0);
        // processQuery.eq(SettleEntity::getSettleType,0);
        // List<SettleEntity> processEntity = settleService.list(processQuery); // 过程结算
        // BigDecimal sumMonthMny = BigDecimal.ZERO;//过程 本期结算金额(无税)
        // BigDecimal sumMonthTaxMny = BigDecimal.ZERO;//过程 本期结算金额
        // for (SettleEntity monthVo : processEntity){
        //     sumMonthMny = ComputeUtil.safeAdd(sumMonthMny, monthVo.getMny());
        //     sumMonthTaxMny = ComputeUtil.safeAdd(sumMonthTaxMny, monthVo.getTaxMny());
        // }
        // LambdaQueryWrapper<SettleEntity> quarterQuery = new LambdaQueryWrapper<>();
        // quarterQuery.eq(SettleEntity::getContractId, contractVO.getId());
        // quarterQuery.in(SettleEntity::getBillState,1,3);
        // quarterQuery.eq(SettleEntity::getDr,0);
        // quarterQuery.eq(SettleEntity::getSettleType,1);
        // List<SettleEntity> quarterEntity = settleService.list(quarterQuery); // 完工结算
        // BigDecimal sumQuarterMny = BigDecimal.ZERO;//完工 本期结算金额(无税)
        // BigDecimal sumQuarterTaxMny = BigDecimal.ZERO;//完工 本期结算金额
        // for (SettleEntity quarterVo : quarterEntity){
        //     sumQuarterMny = ComputeUtil.safeAdd(sumQuarterMny, quarterVo.getMny());
        //     sumQuarterTaxMny = ComputeUtil.safeAdd(sumQuarterTaxMny, quarterVo.getTaxMny());
        // }
        // if (sumQuarterMny.compareTo(sumMonthMny) == 1){ //  完工 本期结算金额(无税) > 过程 本期结算金额(无税)
        //     // 总计划金额无税 = 完工 本期结算金额(无税) - 合同金额（无税）
        //     totalVO.setMoney(sumQuarterMny.subtract(contractVO.getContractMny()));
        // }else {
        //     // 总计划金额无税 = 过程 本期结算金额(无税) - 合同金额（无税）
        //     totalVO.setMoney(sumMonthMny.subtract(contractVO.getContractMny()));
        // }
        // if (sumQuarterTaxMny.compareTo(sumMonthTaxMny) == 1){ //  完工 本期结算金额 > 过程 本期结算金额
        //     //总计划金额 = 完工 本期结算金额 - 合同金额（含税）
        //     totalVO.setTaxMoney(sumQuarterTaxMny.subtract(contractVO.getContractTaxMny()));
        // }else {
        //     //总计划金额 = 过程 本期结算金额 - 合同金额（含税）
        //     totalVO.setTaxMoney(sumMonthTaxMny.subtract(contractVO.getContractTaxMny()));
        // }
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}
