package com.ejianc.business.guarantee.projectReview.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.supplier.bean.SupplierEntity;
import com.ejianc.business.guarantee.supplier.service.ISupplierService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.AdministrativeAreaVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.guarantee.projectReview.mapper.ProjectReviewMapper;
import com.ejianc.business.guarantee.projectReview.bean.ProjectReviewEntity;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewService;

import java.util.List;

/**
 * 项目评审
 *
 * @author generator
 */
@Service("projectReviewService")
public class ProjectReviewServiceImpl extends BaseServiceImpl<ProjectReviewMapper, ProjectReviewEntity> implements IProjectReviewService {

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISupplierService supplierService;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ProjectReviewMapper projectReviewMapper;

    @Override
    public void saveSupplier(ProjectReviewEntity entity) {
        Long supplierId = entity.getSupplierId();
        //根据供应商id查询本地客商库，进行新增或更新
        SupplierEntity localEntity = supplierService.getOne(Wrappers.<SupplierEntity>lambdaQuery()
                .eq(SupplierEntity::getDr, 0)
                .eq(SupplierEntity::getSupplierId, supplierId)
        );
        SupplierDTO supplierDTO = proSupplierApi.selectById(supplierId).getData();
        if(supplierDTO != null){
            SupplierEntity supplierEntity = new SupplierEntity();
            if (localEntity != null) {
                supplierEntity = localEntity;
            }
            supplierEntity.setSupplierId(supplierDTO.getId());//供应商id
            supplierEntity.setSupplierName(supplierDTO.getName());//公司名称
            supplierEntity.setBeginDate(supplierDTO.getRegisterTime());//成立时间
            supplierEntity.setLegalPersonName(supplierDTO.getLegal());//法定代表人
            supplierEntity.setRegisterMny(supplierDTO.getRegisteredCapital());//注册资金
            supplierEntity.setOrgId(entity.getOrgId());
            supplierEntity.setOrgName(entity.getOrgName());
            /**
             * 生成单据编码
             */
            SupplierVO supplierVO = BeanMapper.map(supplierEntity, SupplierVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), supplierVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()){
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行
                supplierEntity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
            supplierService.saveOrUpdate(supplierEntity);
        }


    }
    @Override
    public List<AdministrativeAreaVO> queryAreaList() {
        return projectReviewMapper.queryAreaList();
    }

}
