package com.ejianc.business.guarantee.projectReview.service.impl;

import com.ejianc.business.guarantee.enums.ProjectReviewStatuesEnum;
import com.ejianc.business.guarantee.projectReview.bean.ProjectReviewEndEntity;
import com.ejianc.business.guarantee.projectReview.bean.ProjectReviewEntity;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewEndService;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("projectReviewEnd") 
public class ProjectReviewEndBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectReviewService projectReviewService;

	@Autowired
	private IProjectReviewEndService projectReviewEndService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		/**
		 * 更改项目评审状态为已中止
		 */
		ProjectReviewEndEntity projectReviewEndEntity = projectReviewEndService.selectById(billId);
		if(projectReviewEndEntity != null){
			if(projectReviewEndEntity.getProjectId() != null){
				ProjectReviewEntity projectReviewEntity = projectReviewService.selectById(projectReviewEndEntity.getProjectId());
				projectReviewEntity.setFollowStatus(ProjectReviewStatuesEnum.已中止.getCode());
				projectReviewService.saveOrUpdate(projectReviewEntity);
				logger.info("项目评审中止回调处理成功，已更改跟踪状态为已中止！================{}",projectReviewEntity);
				return CommonResponse.success();

			}
		}
		return CommonResponse.error("空值异常！");

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
