package com.ejianc.business.guarantee.contract.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.bean.RecoveryEntity;
import com.ejianc.business.guarantee.contract.bean.RecoveryFinanceEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contract.service.IRecoveryFinanceService;
import com.ejianc.business.guarantee.contract.service.IRecoveryService;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.framework.auth.session.SessionManager;
import feign.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

@Service("recoveryFinance") 
public class RecoveryFinanceBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractService contractService;

	@Autowired
	private IRecoveryService recoveryService;

	@Autowired
	private IRecoveryFinanceService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		RecoveryFinanceEntity recoveryFinanceEntity = service.selectById(billId);
		if(recoveryFinanceEntity != null){

			RecoveryEntity recoveryEntity = recoveryService.selectById(recoveryFinanceEntity.getRecoveryId());//担保合同代偿
			if(recoveryEntity != null){
//				BigDecimal recoveryMny = recoveryEntity.getRecoveryMny();//代偿金额
//				BigDecimal totalRecoveryMny = BigDecimal.ZERO;//总到账的追偿金额
//				ContractEntity contractEntity = contractService.selectById(recoveryEntity.getContractId());//担保合同评审
//
//				/**
//				 * 查询条件:
//				 * 		1.追偿id
//				 * 		2.未删除
//				 * 		3.已提交，审批通过
//				 * 		4.已到账
//				 * 业务描述:
//				 * 		遍历查询出的数据，将追偿金额累加，与代偿金额比较
//				 * 		相等时将追偿状态改为已追偿，合同状态更改为已结束
//				 */
//				List<RecoveryFinanceEntity> list = service.list(Wrappers.<RecoveryFinanceEntity>lambdaQuery()
//						.eq(RecoveryFinanceEntity::getRecoveryId, recoveryFinanceEntity.getRecoveryId())
//						.eq(RecoveryFinanceEntity::getDr, 0)
//						.in(RecoveryFinanceEntity::getBillState, Arrays.asList(1, 3))
//						.eq(RecoveryFinanceEntity::getIsReceive, 1)
//				);
//				for (RecoveryFinanceEntity financeEntity : list) {
//					if (financeEntity.getRecoveryMny() != null){
//						totalRecoveryMny = totalRecoveryMny.add(financeEntity.getRecoveryMny());
//					} else {
//						return CommonResponse.error("系统错误，请联系管理员！(存在追偿金额为null)");
//					}
//				}
//				if(totalRecoveryMny.compareTo(recoveryMny) == 0){
//					contractEntity.setRecoveryStatus(ContractStatuesEnum.已追偿.getCode());
//					contractEntity.setContractStatus(ContractStatuesEnum.已结束.getCode());
//					contractService.saveOrUpdate(contractEntity);
//				}
				ContractEntity contractEntity = contractService.selectById(recoveryEntity.getContractId());//担保合同评审
				contractEntity.setRecoveryStatus(ContractStatuesEnum.已追偿.getCode());
				contractEntity.setContractStatus(ContractStatuesEnum.已结束.getCode());
				contractService.saveOrUpdate(contractEntity);
			}
			return CommonResponse.success();

		}
		return CommonResponse.error("系统错误,请联系管理员！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
