package com.ejianc.business.guarantee.contract.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.utils.HttpClientUtil;
import com.ejianc.business.guarantee.contract.bean.FinanceEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalFinanceEntity;
import com.ejianc.business.guarantee.contract.service.IFinanceService;
import com.ejianc.business.guarantee.contract.service.IRenewalFinanceService;
import com.ejianc.business.guarantee.contract.service.IRenewalService;
import com.ejianc.business.guarantee.contract.vo.TotalFinanceVO;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contract.vo.ContractVO;

/**
 * 担保合同评审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Guarantee_Contract";//此处需要根据实际修改

    @Autowired
    private IContractService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IFinanceService financeService;

    @Autowired
    private IRenewalService renewalService;

    @Autowired
    private IRenewalFinanceService renewalFinanceService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveOrUpdateVO) {
    	ContractEntity entity = BeanMapper.map(saveOrUpdateVO, ContractEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
        if(entity.getId()==null||entity.getId()==0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam=BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String>billCode=billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()){
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }else{
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setRenewalDate(entity.getGuaranteeTermEndDate());
        System.out.println(ContractStatuesEnum.签订中.getCode());
    	service.saveOrUpdate(entity, false);
    	ContractVO vo = BeanMapper.map(entity, ContractVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
    	ContractEntity entity = service.selectById(id);
    	ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ContractVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org->{
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Contract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(1,3)));
        param.getOrderMap().put("createTime",QueryParam.DESC);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            /**
c             * 1.续保
             * 2.代偿
             * 3.解保
             * 4.过期
             */
            if (null != conditionMap.get("serviceStatus")) {

                Integer serviceStatus = Integer.valueOf(conditionMap.get("serviceStatus").toString());
                if(1 == serviceStatus || 2 == serviceStatus || 3 == serviceStatus){
                    param.getParams().put("contractStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(0,3,4)));
                    param.getParams().put("recoveryStatus", new Parameter(QueryParam.EQ,null));
                    param.getParams().put("renewalStatus", new Parameter(QueryParam.EQ,null));
                }
                if(4 == serviceStatus){
                    param.getParams().put("contractStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(0,3,4)));
                    param.getParams().put("recoveryStatus", new Parameter(QueryParam.EQ, null));

                }


            }

        }

        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 查询历史记录
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryHistoryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryHistoryList(@RequestBody QueryParam param) {
        Long id = Long.parseLong(param.getParams().get("oldReviewId").getValue().toString());
        List<ContractEntity> list = new ArrayList<>();
        while (id != null) {
            id = getContract(id, list);
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("billCode");
//        fuzzyFields.add("projectName");
//        fuzzyFields.add("contractName");
//        fuzzyFields.add("employeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        //分页显示
        IPage<ContractEntity> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        page.setRecords(list);
        page.setTotal(list.size());
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    private Long getContract(Long id, List<ContractEntity> list) {
        ContractEntity contractEntity = service.selectById(id);
        list.add(contractEntity);
        return contractEntity.getOldReviewId();


    }


    /**
     * @Description queryAddressByIP
     *
     * 根据contractId查询财务到账记录
     * 包含原合同、续保的所有到账记录汇总
     *
     * @param contractId
     */
    @RequestMapping(value = "/queryFinanceTotal", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TotalFinanceVO>> queryFinanceTotal(Long contractId) {
        ArrayList<TotalFinanceVO> totalFinanceVOS = new ArrayList<>();
        //获取原合同财务到账记录
        List<FinanceEntity> financeEntities = financeService.list(Wrappers.<FinanceEntity>lambdaQuery()
                .eq(FinanceEntity::getDr, 0)
                .eq(FinanceEntity::getContractId, contractId)
                .in(FinanceEntity::getBillState, Arrays.asList(1, 3))
        );
        //获取原合同续保记录
        List<RenewalEntity> renewalEntities = renewalService.list(Wrappers.<RenewalEntity>lambdaQuery()
                .eq(RenewalEntity::getDr, 0)
                .eq(RenewalEntity::getContractId, contractId)
        );
        List<Long> renewalIds = renewalEntities.stream().map(RenewalEntity::getId).collect(Collectors.toList());
        if(ListUtil.isNotEmpty(renewalIds)){
            //获取续保财务到账记录
            List<RenewalFinanceEntity> renewalFinanceEntities = renewalFinanceService.list(Wrappers.<RenewalFinanceEntity>lambdaQuery()
                    .eq(RenewalFinanceEntity::getDr, 0)
                    .in(RenewalFinanceEntity::getBillState, Arrays.asList(1, 3))
                    .in(RenewalFinanceEntity::getRenewalId, renewalIds)
            );
            if(ListUtil.isNotEmpty(renewalFinanceEntities)){
                List<TotalFinanceVO> renewalFinanceVOS = BeanMapper.mapList(renewalFinanceEntities, TotalFinanceVO.class);
                totalFinanceVOS.addAll(renewalFinanceVOS);
            }
        }

        //组合封装
        if(ListUtil.isNotEmpty(financeEntities)){
            List<TotalFinanceVO> financeVOS = BeanMapper.mapList(financeEntities, TotalFinanceVO.class);
            totalFinanceVOS.addAll(financeVOS);
        }

        if(ListUtil.isNotEmpty(totalFinanceVOS)){
            return CommonResponse.success("查询详情数据成功！",totalFinanceVOS);
        } else {
            return CommonResponse.error("查询数据为空!");
        }

    }


    /**
     * @Description queryAddressByIP
     *
     * 根据ip获取位置信息
     * @param request
     */
    @RequestMapping(value = "/queryAddressByIP", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryAddressByIP(HttpServletRequest request) {
        //获取ip
        String ipAddress = getIpAddress(request);
        String address = getRealAddress(ipAddress);

        return CommonResponse.success("查询详情数据成功！",address);
    }



    /**
     * description 获取客户端IP
     *
     * @param request
     * @return java.lang.String
     * @version 1.0
     */
    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        // 如果是多级代理，那么取第一个IP为客户端IP
        if (ip != null && ip.indexOf(",") != -1) {
            ip = ip.substring(0, ip.indexOf(",")).trim();
        }
        return ip;
    }

    /**
     * description 地址库查询
     *
     * @param ip 地址
     * @return java.lang.String
     * @version 1.0
     */
    public static String getRealAddress(String ip) {
        String result = "";
        try {
            // 加载地址库
            ClassPathResource resource = new ClassPathResource("GeoLite2-City.mmdb");
            DatabaseReader reader = new DatabaseReader.Builder(resource.getInputStream()).build();
            InetAddress inetAddress = InetAddress.getByName(ip);
            CityResponse response = reader.city(inetAddress);
            // 获取所在国家
            String country = response.getCountry().getNames().get("ja");
            // 库内获取不到的IP，访问ali的地域查询
            if (response.getSubdivisions().size() > 0) {
                // 获取所在省份
                String province = response.getSubdivisions().get(0).getNames().get("zh-CN");
                // 获取所在城市
                String city = response.getCity().getNames().get("zh-CN");
                city = city == null ? "" : city;
                result = country + province + city;
            } else {
                result = getAlibaba(ip);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * description ali地域查询
     *
     * @param ip ip地址
     * @return java.lang.String
     * @version 1.0
     */
    public static String getAlibaba(String ip) {
        Map map = new HashMap();
        map.put("ip", ip);
        map.put("accessKey", "alibaba-inc");
        String result = HttpClientUtil.post("http://ip.taobao.com/outGetIpInfo", map);
        Map valueMap = JSONObject.parseObject(result, Map.class);

        // 请求成功，解析响应数据
        if ("query success".equals(valueMap.get("msg"))) {
            Map<String, String> dataMap = (Map<String, String>) valueMap.get("data");
            String country = dataMap.get("country");
            String region = dataMap.get("region");
            String city = dataMap.get("city");
            return country + region + city;
        }
        return "";
    }




}
