package com.ejianc.business.guarantee.waringTest;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;


import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/contractWarn/")
public class ContractWarnController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-proincome-frontend/#/contractRegister/card?id=";

    private static final String PC_B_URL = "/ejc-share-frontend/#/projectPool/projectPoolCard?id=";

    private static final String PC_C_URL = "/ejc-proincome-frontend/#/costAdjust/card?id=";

    private static final String PC_D_URL = "/ejc-proincome-frontend/#/contractReview/card?id=";

    private static final String PC_E_URL = "/ejc-proincome-frontend/#/claimRecords/card?id=";

    private static final String PC_A_URL = "/ejc-proincome-frontend/#/";

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private ITenantApi tenantApi;


    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectPoolApi projectSetApi;

    @PostMapping(value = "testWarnExecute")
    public CommonResponse<String> budgetWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {//循环每个租户数据
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
//            1、根据租户合同纬度，查询合同
//            2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
//            3、根据预警设置判断该合同数据属于哪个等级
//            4、符合等级，则拼接预警数据，并保存到list
//            5、发送数据
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

            List<Integer> dayList = new ArrayList<>();
            dayList.add(0);
            dayList.add(1);
            dayList.add(3);
            if (ListUtil.isNotEmpty(dayList)) {
                for (Integer day : dayList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
//                    Long orgId = contractEntity.getOrgId();
//                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
//                    if(orgVO==null){
//                        continue;
//                    }
//                    String innerCode = orgVO.getInnerCode();
//                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的innerCode进行父级查找
                     * */
//                    logger.info("parentIds______"+innerCode);
//                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
//                        /** 反向查找 */
//                        Long pOrgId = Long.parseLong(parentIds[i1]);
//                        for (int j = 0 ; j < orgSettings.size(); j++) {
//                            JSONObject set = orgSettings.getJSONObject(j);
//                            if (pOrgId.equals(set.getLong("orgId"))) {
//                                orgSet = set;
//                                break;
//                            }
//                        }
//                        if(orgSet!=null){
//                            break;
//                        }
//                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }

                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        /** 间隔天数 */
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");

                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        /*BigDecimal overAmtHigh = null;
                        BigDecimal overAmtMeddle = null;
                        BigDecimal overAmtLow = null;*/


                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if (day > new Integer(parameterValue.toString())) {
                                    //overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if (day > new Integer(parameterValue.toString())) {
                                    //overAmtMeddle = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if (day > new Integer(parameterValue.toString())) {
                                    //overAmtLow = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-测试");
                            vo.setPcTitle("测试");
                            vo.setPcUrl(PC_URL);
                            vo.setOrgId(1406795679670312962L);
                            vo.setSendOrgId("1406795679670312962");
                            vo.setOrgName("郑州一建集团有限公司");
                            vo.setSourceId(null);
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#test#", "测试高")
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#test#", "测试中")
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", "测试低")
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }

        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }


    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("contractCode").toString());
            vo.setPcTitle("施工合同");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));


            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#contractName#", m.get("contractName").toString())
                            .replaceAll("#signDate#", m.get("signDate").toString())
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }
}
