/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.guarantee.contractChange.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contractChange.bean.ContractChangeEntity;
import com.ejianc.business.guarantee.contractChange.mapper.ContractChangeMapper;
import com.ejianc.business.guarantee.contractChange.service.IContractChangeService;
import com.ejianc.business.guarantee.contractChange.service.IContractHistoryService;
import com.ejianc.business.guarantee.contractChange.vo.ContractChangeVO;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractChangeService")
public class ContractChangeServiceImpl
extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity>
implements IContractChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractHistoryService historyService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_CODE = "Guarantee_Contract_Change";

    @Override
    public ContractChangeVO saveOrUpdate(ContractChangeVO saveOrUpdateVO) {
        ContractChangeEntity entity = (ContractChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractChangeEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, (Object)entity.getBillCode());
            lambda.ne(ContractChangeEntity::getOldReviewId, (Object)entity.getOldReviewId());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
                entity.setBillCode(null);
            }
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, (Object)entity.getBillCode());
            lambda.ne(ContractChangeEntity::getOldReviewId, (Object)entity.getOldReviewId());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)ContractStatuesEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getOldReviewId());
        this.contractService.update((Wrapper)updateWrapper);
        ContractChangeEntity contractChangeEntity = (ContractChangeEntity)((Object)this.selectById(entity.getId()));
        return (ContractChangeVO)BeanMapper.map((Object)((Object)contractChangeEntity), ContractChangeVO.class);
    }

    @Override
    public List<ContractChangeVO> queryChangeRecord(Long id) {
        List contractChangeEntities = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(ContractChangeEntity::getBillState, Arrays.asList(1, 3))).eq(ContractChangeEntity::getOldReviewId, (Object)id));
        List<ContractChangeVO> contractChangeVOS = BeanMapper.mapList((Iterable)contractChangeEntities, ContractChangeVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        int index = 1;
        for (ContractChangeVO changeVO : contractChangeVOS) {
            changeVO.setHistoryCode(contractEntity.getBillCode() + "-" + index);
            ++index;
        }
        contractChangeVOS = contractChangeVOS.stream().sorted(Comparator.comparing(BaseVO::getCreateTime).reversed()).collect(Collectors.toList());
        return contractChangeVOS;
    }
}

