package com.ejianc.business.guarantee.contract.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.guarantee.contract.mapper.RenewalMapper;
import com.ejianc.business.guarantee.contract.bean.RenewalEntity;
import com.ejianc.business.guarantee.contract.service.IRenewalService;

import java.util.Arrays;
import java.util.List;

/**
 * 担保合同续保
 * 
 * @author generator
 * 
 */
@Service("renewalService")
public class RenewalServiceImpl extends BaseServiceImpl<RenewalMapper, RenewalEntity> implements IRenewalService{
    @Override
    public List<RenewalEntity> getListByConId(Long contractId) {
        return this.list(Wrappers.<RenewalEntity>lambdaQuery()
                .eq(RenewalEntity::getContractId, contractId)
                .in(RenewalEntity::getBillState, Arrays.asList(1, 3))
        );
    }
}
