package com.ejianc.business.guarantee.contract.service.impl;

import com.ejianc.business.guarantee.contract.bean.ContractEndEntity;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.service.IContractEndService;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewEndService;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("contractEnd") 
public class ContractEndBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractService contractService;

	@Autowired
	private IContractEndService contractEndService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		/**
		 * 更改合同状态为已过期
		 */
		ContractEndEntity contractEndEntity = contractEndService.selectById(billId);
		if(contractEndEntity != null){
			if(contractEndEntity.getContractId() != null){
				ContractEntity contractEntity = contractService.selectById(contractEndEntity.getContractId());
				contractEntity.setContractStatus(ContractStatuesEnum.已过期.getCode());
				contractService.saveOrUpdate(contractEntity);
				logger.info("合同过期回调处理成功，已更改跟踪状态为已过期！================{}",contractEntity);
				return CommonResponse.success();

			}
		}
		return CommonResponse.error("空值异常！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
