package com.ejianc.business.guarantee.contract.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.guarantee.contract.bean.ContractDetailEntity;
import com.ejianc.business.guarantee.contract.bean.ContractInfoEntity;
/**
 * 担保合同评审
 * 
 * @author generator
 * 
 */
 @TableName("ejc_guarantee_contract")
public class ContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 合同编号
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="apply_area")
    private String applyArea; // 申请地区
    @TableField(value="apply_area_name")
    private String applyAreaName; // 申请地区名称
    @TableField(value="employee_id")
    private Long employeeId; // 委托保证人
    @TableField(value="employee_name")
    private String employeeName; // 委托保证人名称
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="end_date")
    private Date endDate; // 竣工日期
    @TableField(value="duration")
    private String duration; // 工期
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同造价(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同造价(含税)
    @TableField(value="owner")
    private Long owner; // 业主
    @TableField(value="owner_name")
    private String ownerName; // 业主名称
    @TableField(value="contractor_id")
    private Long contractorId; // 承包商
    @TableField(value="contractor_name")
    private String contractorName; // 承包商名称
    @TableField(value="project_type")
    private Long projectType; // 项目类型
    @TableField(value="project_type_name")
    private String projectTypeName; // 项目类型名称
    @TableField(value="construct_procedure")
    private Integer constructProcedure; // 开发施工手续（1：齐全 2：不齐全）
    @TableField(value="source_funds")
    private Long sourceFunds; // 资金来源
    @TableField(value="source_funds_name")
    private String sourceFundsName; // 资金来源名称
    @TableField(value="applicant")
    private Long applicant; // 申请人
    @TableField(value="applicant_name")
    private String applicantName; // 申请名称
    @TableField(value="register_mny")
    private BigDecimal registerMny; // 注册资金
    @TableField(value="litigation_cases")
    private Integer litigationCases; // 诉讼案件（1：较多 2：较少 3：无）
    @TableField(value="legal_person")
    private Long legalPerson; // 法定代表人
    @TableField(value="legal_person_name")
    private String legalPersonName; // 法定代表人名称
    @TableField(value="establish_date")
    private Date establishDate; // 成立时间
    @TableField(value="quality_level_name")
    private String qualityLevelName; // 资质等级
    @TableField(value="client")
    private Long client; // 委托人
    @TableField(value="client_name")
    private String clientName; // 委托人名称
    @TableField(value="client_phone")
    private String clientPhone; // 联系电话
    @TableField(value="litigation_address")
    private Long litigationAddress; // 诉讼地
    @TableField(value="litigation_address_name")
    private String litigationAddressName; // 诉讼地名称
    @TableField(value="guarantee_type")
    private Long guaranteeType; // 担保类型
    @TableField(value="guarantee_type_name")
    private String guaranteeTypeName; // 担保类型名称
    @TableField(value="ensure_duty")
    private Long ensureDuty; // 保证责任
    @TableField(value="ensure_duty_name")
    private String ensureDutyName; // 保证责任名称
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="project_address_name")
    private String projectAddressName; // 项目地址名称
    @TableField(value="project_province")
    private String projectProvince; // 项目省
    @TableField(value="project_city")
    private String projectCity; // 项目市
    @TableField(value="project_region")
    private String projectRegion; // 项目区县
    @TableField(value="project_region_code")
    private String projectRegionCode; // 项目区县编码
    @TableField(value="base_mny")
    private BigDecimal baseMny; // 初始担保金额
    @TableField(value="base_tax_mny")
    private BigDecimal baseTaxMny; // 初始担保金额（含税）
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前担保金额
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前担保金额（含税）
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中担保金额
    @TableField(value="changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中担保金额（含税）
    @TableField(value="base_premium_mny")
    private BigDecimal basePremiumMny; // 初始保费金额
    @TableField(value="base_premium_tax_mny")
    private BigDecimal basePremiumTaxMny; // 初始保费金额(含税)
    @TableField(value="base_premium_tax_rate")
    private BigDecimal basePremiumTaxRate; // 初始保费税率
    @TableField(value="guarantee_return_tax_mny")
    private BigDecimal guaranteeReturnTaxMny; // 现金反担保金额（类似押金）
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="before_premium_mny")
    private BigDecimal beforePremiumMny; // 变更前保费金额
    @TableField(value="before_premium_tax_mny")
    private BigDecimal beforePremiumTaxMny; // 变更前保费金额(含税)
    @TableField(value="changing_premium_mny")
    private BigDecimal changingPremiumMny; // 变更中保费金额
    @TableField(value="changing_premium_tax_mny")
    private BigDecimal changingPremiumTaxMny; // 变更中保费金额(含税)
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="guarantee_effect_date")
    private Date guaranteeEffectDate; // 担保生效期
    @TableField(value="guarantee_term_start_date")
    private Date guaranteeTermStartDate; // 担保收费开始日期
    @TableField(value="guarantee_term_end_date")
    private Date guaranteeTermEndDate; // 担保收费结束日期
    @TableField(value="guarantee_mode")
    private Long guaranteeMode; // 担保方式
    @TableField(value="guarantee_mode_name")
    private String guaranteeModeName; // 担保方式名称
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="old_review_id")
    private Long oldReviewId; // 原评审编号
    @TableField(value="self_code")
    private String selfCode; // 自定义编号
    @TableField(value = "contract_status")
    private Integer contractStatus;//合同状态(1-在保 2-续保 3-解保 4-代偿 5-结束)
    @TableField(value = "recovery_status")
    private Integer recoveryStatus;//追偿状态(1-追偿中 2-已追偿)
    @TableField(value = "abandon_status")
    private Integer abandonStatus;//废弃状态(1-正常 2-已废弃)
    @TableField(value = "renewal_status")
    private Integer renewalStatus;//续保状态(1-续保中 2-已续保)
    @TableField(value = "finance_status")
    private Integer financeStatus;//财务确认状态(0-未到账 1-已全部到账 2-未完全到账)
    @TableField(value="guarantee_tax_mny")
    private BigDecimal guaranteeTaxMny; // 担保金额
    @TableField(value="guarantee_mny_per")
    private BigDecimal guaranteeMnyPer; // 担保额比例
    @TableField(value="return_tax_bond")
    private BigDecimal returnTaxBond; // 反担保保证金
    @TableField(value="bond_per")
    private BigDecimal bondPer; //保证金比例
    @TableField(value="renewal_date")
    private Date renewalDate; //续保日期
    @TableField(value="letter_date")
    private Date letterDate; //出函时间
    @TableField(value = "benefit_person_name")
    private String benefitPersonName;//受益人


    @TableField(exist=false)
    @SubEntity(serviceName="contractDetailService",pidName = "contractId")
    private List<ContractDetailEntity> contractDetailList = new ArrayList<>(); // 联合保证详情子表
    @TableField(exist=false)
    @SubEntity(serviceName="contractInfoService",pidName = "contractId")
    private List<ContractInfoEntity> contractInfoList = new ArrayList<>(); // 个人信用反担保信息子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getApplyArea() {
        return applyArea;
    }

    public void setApplyArea(String applyArea) {
        this.applyArea = applyArea;
    }
    public String getApplyAreaName() {
        return applyAreaName;
    }

    public void setApplyAreaName(String applyAreaName) {
        this.applyAreaName = applyAreaName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }
    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Long getContractorId() {
        return contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public String getContractorName() {
        return contractorName;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }

    public Long getProjectType() {
        return projectType;
    }

    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Integer getConstructProcedure() {
        return constructProcedure;
    }

    public void setConstructProcedure(Integer constructProcedure) {
        this.constructProcedure = constructProcedure;
    }
    public Long getSourceFunds() {
        return sourceFunds;
    }

    public void setSourceFunds(Long sourceFunds) {
        this.sourceFunds = sourceFunds;
    }
    public String getSourceFundsName() {
        return sourceFundsName;
    }

    public void setSourceFundsName(String sourceFundsName) {
        this.sourceFundsName = sourceFundsName;
    }
    public Long getApplicant() {
        return applicant;
    }

    public void setApplicant(Long applicant) {
        this.applicant = applicant;
    }
    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }
    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }
    public Integer getLitigationCases() {
        return litigationCases;
    }

    public void setLitigationCases(Integer litigationCases) {
        this.litigationCases = litigationCases;
    }
    public Long getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(Long legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getLegalPersonName() {
        return legalPersonName;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }
    public Date getEstablishDate() {
        return establishDate;
    }

    public void setEstablishDate(Date establishDate) {
        this.establishDate = establishDate;
    }
    public String getQualityLevelName() {
        return qualityLevelName;
    }

    public void setQualityLevelName(String qualityLevelName) {
        this.qualityLevelName = qualityLevelName;
    }
    public Long getClient() {
        return client;
    }

    public void setClient(Long client) {
        this.client = client;
    }
    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }
    public String getClientPhone() {
        return clientPhone;
    }

    public void setClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
    }
    public Long getLitigationAddress() {
        return litigationAddress;
    }

    public void setLitigationAddress(Long litigationAddress) {
        this.litigationAddress = litigationAddress;
    }
    public String getLitigationAddressName() {
        return litigationAddressName;
    }

    public void setLitigationAddressName(String litigationAddressName) {
        this.litigationAddressName = litigationAddressName;
    }
    public Long getGuaranteeType() {
        return guaranteeType;
    }

    public void setGuaranteeType(Long guaranteeType) {
        this.guaranteeType = guaranteeType;
    }
    public String getGuaranteeTypeName() {
        return guaranteeTypeName;
    }

    public void setGuaranteeTypeName(String guaranteeTypeName) {
        this.guaranteeTypeName = guaranteeTypeName;
    }
    public Long getEnsureDuty() {
        return ensureDuty;
    }

    public void setEnsureDuty(Long ensureDuty) {
        this.ensureDuty = ensureDuty;
    }
    public String getEnsureDutyName() {
        return ensureDutyName;
    }

    public void setEnsureDutyName(String ensureDutyName) {
        this.ensureDutyName = ensureDutyName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getProjectAddressName() {
        return projectAddressName;
    }

    public void setProjectAddressName(String projectAddressName) {
        this.projectAddressName = projectAddressName;
    }
    public String getProjectProvince() {
        return projectProvince;
    }

    public void setProjectProvince(String projectProvince) {
        this.projectProvince = projectProvince;
    }
    public String getProjectCity() {
        return projectCity;
    }

    public void setProjectCity(String projectCity) {
        this.projectCity = projectCity;
    }
    public String getProjectRegion() {
        return projectRegion;
    }

    public void setProjectRegion(String projectRegion) {
        this.projectRegion = projectRegion;
    }
    public String getProjectRegionCode() {
        return projectRegionCode;
    }

    public void setProjectRegionCode(String projectRegionCode) {
        this.projectRegionCode = projectRegionCode;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public BigDecimal getBasePremiumMny() {
        return basePremiumMny;
    }

    public void setBasePremiumMny(BigDecimal basePremiumMny) {
        this.basePremiumMny = basePremiumMny;
    }
    public BigDecimal getBasePremiumTaxMny() {
        return basePremiumTaxMny;
    }

    public void setBasePremiumTaxMny(BigDecimal basePremiumTaxMny) {
        this.basePremiumTaxMny = basePremiumTaxMny;
    }
    public BigDecimal getBasePremiumTaxRate() {
        return basePremiumTaxRate;
    }

    public void setBasePremiumTaxRate(BigDecimal basePremiumTaxRate) {
        this.basePremiumTaxRate = basePremiumTaxRate;
    }
    public BigDecimal getGuaranteeReturnTaxMny() {
        return guaranteeReturnTaxMny;
    }

    public void setGuaranteeReturnTaxMny(BigDecimal guaranteeReturnTaxMny) {
        this.guaranteeReturnTaxMny = guaranteeReturnTaxMny;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public BigDecimal getBeforePremiumMny() {
        return beforePremiumMny;
    }

    public void setBeforePremiumMny(BigDecimal beforePremiumMny) {
        this.beforePremiumMny = beforePremiumMny;
    }
    public BigDecimal getBeforePremiumTaxMny() {
        return beforePremiumTaxMny;
    }

    public void setBeforePremiumTaxMny(BigDecimal beforePremiumTaxMny) {
        this.beforePremiumTaxMny = beforePremiumTaxMny;
    }
    public BigDecimal getChangingPremiumMny() {
        return changingPremiumMny;
    }

    public void setChangingPremiumMny(BigDecimal changingPremiumMny) {
        this.changingPremiumMny = changingPremiumMny;
    }
    public BigDecimal getChangingPremiumTaxMny() {
        return changingPremiumTaxMny;
    }

    public void setChangingPremiumTaxMny(BigDecimal changingPremiumTaxMny) {
        this.changingPremiumTaxMny = changingPremiumTaxMny;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public Date getGuaranteeEffectDate() {
        return guaranteeEffectDate;
    }

    public void setGuaranteeEffectDate(Date guaranteeEffectDate) {
        this.guaranteeEffectDate = guaranteeEffectDate;
    }
    public Date getGuaranteeTermStartDate() {
        return guaranteeTermStartDate;
    }

    public void setGuaranteeTermStartDate(Date guaranteeTermStartDate) {
        this.guaranteeTermStartDate = guaranteeTermStartDate;
    }
    public Date getGuaranteeTermEndDate() {
        return guaranteeTermEndDate;
    }

    public void setGuaranteeTermEndDate(Date guaranteeTermEndDate) {
        this.guaranteeTermEndDate = guaranteeTermEndDate;
    }
    public Long getGuaranteeMode() {
        return guaranteeMode;
    }

    public void setGuaranteeMode(Long guaranteeMode) {
        this.guaranteeMode = guaranteeMode;
    }
    public String getGuaranteeModeName() {
        return guaranteeModeName;
    }

    public void setGuaranteeModeName(String guaranteeModeName) {
        this.guaranteeModeName = guaranteeModeName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Long getOldReviewId() {
        return oldReviewId;
    }

    public void setOldReviewId(Long oldReviewId) {
        this.oldReviewId = oldReviewId;
    }

    public String getSelfCode() {
        return selfCode;
    }

    public void setSelfCode(String selfCode) {
        this.selfCode = selfCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Integer getRecoveryStatus() {
        return recoveryStatus;
    }

    public void setRecoveryStatus(Integer recoveryStatus) {
        this.recoveryStatus = recoveryStatus;
    }

    public Integer getAbandonStatus() {
        return abandonStatus;
    }

    public void setAbandonStatus(Integer abandonStatus) {
        this.abandonStatus = abandonStatus;
    }

    public Integer getRenewalStatus() {
        return renewalStatus;
    }

    public void setRenewalStatus(Integer renewalStatus) {
        this.renewalStatus = renewalStatus;
    }

    public List<ContractDetailEntity> getContractDetailList() {
        return contractDetailList;
    }

    public void setContractDetailList(List<ContractDetailEntity> contractDetailList) {
        this.contractDetailList = contractDetailList;
    }

    public List<ContractInfoEntity> getContractInfoList() {
        return contractInfoList;
    }

    public void setContractInfoList(List<ContractInfoEntity> contractInfoList) {
        this.contractInfoList = contractInfoList;
    }

    public Integer getFinanceStatus() {
        return financeStatus;
    }

    public void setFinanceStatus(Integer financeStatus) {
        this.financeStatus = financeStatus;
    }

    public BigDecimal getGuaranteeTaxMny() {
        return guaranteeTaxMny;
    }

    public void setGuaranteeTaxMny(BigDecimal guaranteeTaxMny) {
        this.guaranteeTaxMny = guaranteeTaxMny;
    }

    public BigDecimal getGuaranteeMnyPer() {
        return guaranteeMnyPer;
    }

    public void setGuaranteeMnyPer(BigDecimal guaranteeMnyPer) {
        this.guaranteeMnyPer = guaranteeMnyPer;
    }

    public BigDecimal getReturnTaxBond() {
        return returnTaxBond;
    }

    public void setReturnTaxBond(BigDecimal returnTaxBond) {
        this.returnTaxBond = returnTaxBond;
    }

    public BigDecimal getBondPer() {
        return bondPer;
    }

    public void setBondPer(BigDecimal bondPer) {
        this.bondPer = bondPer;
    }

    public Date getRenewalDate() {
        return renewalDate;
    }

    public void setRenewalDate(Date renewalDate) {
        this.renewalDate = renewalDate;
    }

    public Date getLetterDate() {
        return letterDate;
    }

    public void setLetterDate(Date letterDate) {
        this.letterDate = letterDate;
    }

    public String getBenefitPersonName() {
        return benefitPersonName;
    }

    public void setBenefitPersonName(String benefitPersonName) {
        this.benefitPersonName = benefitPersonName;
    }
}
