package com.ejianc.business.guarantee.homePage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.bean.RecoveryEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalEntity;
import com.ejianc.business.guarantee.contract.service.IContractEndService;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contract.service.IRecoveryService;
import com.ejianc.business.guarantee.contract.service.IRenewalService;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.business.guarantee.homePage.service.IHomePageService;
import com.ejianc.business.guarantee.homePage.vo.ProjectBaseVO;
import com.ejianc.business.guarantee.homePage.vo.TypeVO;
import com.ejianc.business.guarantee.letter.bean.GuaranteeLetterEntity;
import com.ejianc.business.guarantee.letter.service.IGuaranteeLetterService;
import com.ejianc.business.guarantee.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.guarantee.relieve.service.IContractRelieveService;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.List;


/**
 *
 *  担保管理门户页面
 *
 */
@Controller
@RequestMapping("homePage")
public class HomePageController{

    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractRelieveService contractRelieveService;
    @Autowired
    private IRecoveryService recoveryService;
    @Autowired
    private IRenewalService renewalService;
    @Autowired
    private IGuaranteeLetterService guaranteeLetterService;
    @Autowired
    private IContractEndService contractEndService;
    @Autowired
    private IHomePageService service;

    /**
     * @Description 风险项目概况统计
     */

    @RequestMapping(value = "/projectBase", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectBaseVO> RiskProjectBase() {
        ProjectBaseVO projectBaseVO = new ProjectBaseVO();
        Date date = new Date();
        String beginDate = DateFormatUtils.format(DateUtil.beginOfYear(date),"yyyy-MM-dd");
        String endDate = DateFormatUtils.format(DateUtil.endOfYear(date),"yyyy-MM-dd");
        List<ContractEntity> contractList = contractService.list(Wrappers.<ContractEntity>lambdaQuery()
                .eq(ContractEntity::getDr, 0)
                .in(ContractEntity::getBillState, Arrays.asList(1, 3))
                .gt(ContractEntity::getCommitDate, beginDate)
                .lt(ContractEntity::getCommitDate, endDate)
        );
        //新增保函数
        List<GuaranteeLetterEntity> letterList = guaranteeLetterService.list(Wrappers.<GuaranteeLetterEntity>lambdaQuery()
                .eq(GuaranteeLetterEntity::getDr, 0)
                .in(GuaranteeLetterEntity::getBillState, Arrays.asList(1, 3))
                .gt(GuaranteeLetterEntity::getCreateTime, beginDate)
                .lt(GuaranteeLetterEntity::getCreateTime, endDate)
        );
        //在保数量
        long guaranteeNum = contractList.stream().filter(s ->
                ContractStatuesEnum.在保.getCode().equals(s.getContractStatus())
        ).count();
        //解保数量
        List<ContractRelieveEntity> relieveList = contractRelieveService.list(Wrappers.<ContractRelieveEntity>lambdaQuery()
                .eq(ContractRelieveEntity::getDr, 0)
                .in(ContractRelieveEntity::getBillState, Arrays.asList(1, 3))
                .gt(ContractRelieveEntity::getCreateTime, beginDate)
                .lt(ContractRelieveEntity::getCreateTime, endDate)
        );
        //代偿数量
        List<RecoveryEntity> recoveryList = recoveryService.list(Wrappers.<RecoveryEntity>lambdaQuery()
                .eq(RecoveryEntity::getDr, 0)
                .in(RecoveryEntity::getBillState, Arrays.asList(1, 3))
                .gt(RecoveryEntity::getCreateTime, beginDate)
                .lt(RecoveryEntity::getCreateTime, endDate)
        );
        //续保数量
        List<RenewalEntity> renewalList = renewalService.list(Wrappers.<RenewalEntity>lambdaQuery()
                .eq(RenewalEntity::getDr, 0)
                .in(RenewalEntity::getBillState, Arrays.asList(1, 3))
                .gt(RenewalEntity::getCreateTime, beginDate)
                .lt(RenewalEntity::getCreateTime, endDate)
        );
        //到期担保数
        projectBaseVO.setAddNum((long) letterList.size());
        projectBaseVO.setGuaranteeNum(guaranteeNum);
        projectBaseVO.setRelieveNum((long) relieveList.size());
        projectBaseVO.setRecoveryNum((long) recoveryList.size());
        projectBaseVO.setRenewalNum((long) renewalList.size());
        return CommonResponse.success("查询详情数据成功！", projectBaseVO);
    }


    /**
     * @param param
     * @Description queryGuaranteeType 查询担保类型分布
     */
    @RequestMapping(value = "/queryGuaranteeType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryGuaranteeType(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /**
         *实现分页
         */
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.queryGuaranteeType(wrapper);

        return CommonResponse.success("查询担保类型分布数据成功！", typeVOS);
    }
}
