package com.ejianc.business.guarantee.homePage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.bean.RecoveryEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalEntity;
import com.ejianc.business.guarantee.contract.service.IContractEndService;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contract.service.IRecoveryService;
import com.ejianc.business.guarantee.contract.service.IRenewalService;
import com.ejianc.business.guarantee.contract.vo.ContractVO;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.business.guarantee.homePage.service.IHomePageService;
import com.ejianc.business.guarantee.homePage.vo.ProjectBaseVO;
import com.ejianc.business.guarantee.homePage.vo.TypeVO;
import com.ejianc.business.guarantee.homePage.vo.areaVO.AreaDataVO;
import com.ejianc.business.guarantee.homePage.vo.areaVO.InfoAreaVO;
import com.ejianc.business.guarantee.letter.bean.GuaranteeLetterEntity;
import com.ejianc.business.guarantee.letter.service.IGuaranteeLetterService;
import com.ejianc.business.guarantee.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.guarantee.relieve.service.IContractRelieveService;
import com.ejianc.business.guarantee.utils.EJCDateUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.business.guarantee.utils.AddressResolutionUtil.*;


/**
 *
 *  担保管理门户页面
 *
 */
@Controller
@RequestMapping("homePage")
public class HomePageController{

    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractRelieveService contractRelieveService;
    @Autowired
    private IRecoveryService recoveryService;
    @Autowired
    private IRenewalService renewalService;
    @Autowired
    private IGuaranteeLetterService guaranteeLetterService;
    @Autowired
    private IContractEndService contractEndService;
    @Autowired
    private IHomePageService service;

    /**
     * @Description 风险项目概况统计
     */

    @RequestMapping(value = "/projectBase", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectBaseVO> RiskProjectBase() {
        ProjectBaseVO projectBaseVO = new ProjectBaseVO();
        Date date = new Date();
        String beginDate = DateFormatUtils.format(DateUtil.beginOfYear(date),"yyyy-MM-dd");
        String endDate = DateFormatUtils.format(DateUtil.endOfYear(date),"yyyy-MM-dd");
        List<ContractEntity> contractList = contractService.list(Wrappers.<ContractEntity>lambdaQuery()
                .eq(ContractEntity::getDr, 0)
                .in(ContractEntity::getBillState, Arrays.asList(1, 3))
                .gt(ContractEntity::getCommitDate, beginDate)
                .lt(ContractEntity::getCommitDate, endDate)
        );
        //新增保函数
        List<GuaranteeLetterEntity> letterList = guaranteeLetterService.list(Wrappers.<GuaranteeLetterEntity>lambdaQuery()
                .eq(GuaranteeLetterEntity::getDr, 0)
                .in(GuaranteeLetterEntity::getBillState, Arrays.asList(1, 3))
                .gt(GuaranteeLetterEntity::getCreateTime, beginDate)
                .lt(GuaranteeLetterEntity::getCreateTime, endDate)
        );
        //在保数量
        long guaranteeNum = contractList.stream().filter(s ->
                ContractStatuesEnum.在保.getCode().equals(s.getContractStatus())
        ).count();
        //解保数量
        List<ContractRelieveEntity> relieveList = contractRelieveService.list(Wrappers.<ContractRelieveEntity>lambdaQuery()
                .eq(ContractRelieveEntity::getDr, 0)
                .in(ContractRelieveEntity::getBillState, Arrays.asList(1, 3))
                .gt(ContractRelieveEntity::getCreateTime, beginDate)
                .lt(ContractRelieveEntity::getCreateTime, endDate)
        );
        //代偿数量
        List<RecoveryEntity> recoveryList = recoveryService.list(Wrappers.<RecoveryEntity>lambdaQuery()
                .eq(RecoveryEntity::getDr, 0)
                .in(RecoveryEntity::getBillState, Arrays.asList(1, 3))
                .gt(RecoveryEntity::getCreateTime, beginDate)
                .lt(RecoveryEntity::getCreateTime, endDate)
        );
        //续保数量
        List<RenewalEntity> renewalList = renewalService.list(Wrappers.<RenewalEntity>lambdaQuery()
                .eq(RenewalEntity::getDr, 0)
                .in(RenewalEntity::getBillState, Arrays.asList(1, 3))
                .gt(RenewalEntity::getCreateTime, beginDate)
                .lt(RenewalEntity::getCreateTime, endDate)
        );
        //到期担保数
        projectBaseVO.setAddNum((long) letterList.size());
        projectBaseVO.setGuaranteeNum(guaranteeNum);
        projectBaseVO.setRelieveNum((long) relieveList.size());
        projectBaseVO.setRecoveryNum((long) recoveryList.size());
        projectBaseVO.setRenewalNum((long) renewalList.size());
        return CommonResponse.success("查询详情数据成功！", projectBaseVO);
    }


    /**
     * @param param
     * @Description queryGuaranteeType 查询担保类型分布
     */
    @RequestMapping(value = "/queryGuaranteeType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryGuaranteeType(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /**
         *实现分页
         */
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.queryGuaranteeType(wrapper);

        return CommonResponse.success("查询担保类型分布数据成功！", typeVOS);
    }

    /**
     * 法务门户-应诉法院地图数据
     *
     * @param name
     * @param dateIn
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/getInfoArea", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getInfoArea(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "dateIn", required = false) String dateIn,
                                                  @RequestParam(value = "orgId", required = false) Long orgId) {
        return this.infoArea(name, dateIn, orgId);
    }
    public CommonResponse<JSONObject> infoArea(String name, String dateIn, Long orgId) {
        //今年
        dateIn = EJCDateUtil.getYear() + "";


        QueryWrapper<ContractEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(dateIn)) {
            queryWrapper.eq("DATE_FORMAT(first_start_date,\"%Y\")", dateIn);
        }
        queryWrapper.in("bill_state", Arrays.asList(1, 3));
        queryWrapper.ne("contract_status", 0);
        List<ContractEntity> list = contractService.list(queryWrapper);

        List<InfoAreaVO> infoAreaVOS = new ArrayList<>();
        if (ListUtil.isNotEmpty(list)) {
            List<ContractVO> infoRegisterVOS = BeanMapper.mapList(list, ContractVO.class);
            for (ContractVO infoRegisterVO : infoRegisterVOS) {
                InfoAreaVO infoAreaVO = new InfoAreaVO();
                infoAreaVO.setId(infoRegisterVO.getId());
                infoAreaVO.setOrgId(infoRegisterVO.getOrgId());
                infoAreaVO.setProjectName(infoRegisterVO.getProjectName());
                if (StringUtils.isNotEmpty(infoRegisterVO.getApplyAreaName())) {
                    String areaName = null;
                    areaName = infoRegisterVO.getApplyAreaName().replace("/", "");
                    infoAreaVO.setAreaName(areaName);
                } else {
                    infoAreaVO.setAreaName(infoRegisterVO.getApplyAreaName());
                }
                infoAreaVOS.add(infoAreaVO);
            }
        }
        List<Long> ids = new ArrayList<>();
        Set<String> provinceSet = new HashSet<>();
        Set<String> citySet = new HashSet<>();
        Set<String> countySet = new HashSet<>();
        String pname = null;
        for (InfoAreaVO vo : infoAreaVOS) {
            ids.add(vo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getAreaName())) {
                if (vo.getAreaName().equals("台湾省")) {
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                } else {
                    Map<String, String> areaMap = addressResolution(vo.getAreaName());
                    if (areaMap != null) {
                        String province = areaMap.get("province") == null ? "其他" : areaMap.get("province");
                        String city = areaMap.get("city") == null ? "其他" : areaMap.get("city");
                        String county = areaMap.get("county") == null ? "其他" : areaMap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);
                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(name) && city.equals(name)) {
                            pname = province;
                        }
                    } else {
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");
                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            } else {
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");
                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }

        }

        String rangeType = null;
        List<AreaDataVO> dataVOS = new ArrayList<>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(name)) {
            if (provinceSet.contains(name)) {// 如果选择省
                rangeType = getProvincePinYin(name);
                dataVOS = projectCountByName(name, infoAreaVOS, 0);
            } else if (citySet.contains(name)) {
                rangeType = getProvincePinYin(pname) + "-" + getNamePinYinChar(name, 1);
                dataVOS = projectCountByName(name, infoAreaVOS, 1);
            }

        } else {
            if (provinceSet.size() == 1) {//同一省份
                if (citySet.size() == 1) {// 如果是同一市
                    rangeType = getProvincePinYin(provinceSet.iterator().next()) + "-" + getNamePinYinChar(citySet.iterator().next(), 1);
                    Map<String, AreaDataVO> countyMap = new HashMap<>();
                    for (InfoAreaVO vo : infoAreaVOS) {
                        String county = vo.getCounty();
                        if (!countyMap.containsKey(county)) {
                            AreaDataVO pvo = new AreaDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            countyMap.put(county, pvo);
                        } else {
                            AreaDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            countyMap.put(county, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<AreaDataVO>(countyMap.values());
                    Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
                    for (AreaDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                            dataVO.setInfoAreaVOS(projectCountVOS);
                        }
                    }
                } else {
                    rangeType = getProvincePinYin(provinceSet.iterator().next());
                    Map<String, AreaDataVO> cityMap = new HashMap<>();
                    for (InfoAreaVO vo : infoAreaVOS) {
                        String city = vo.getCity();
                        if (!cityMap.containsKey(city)) {
                            AreaDataVO pvo = new AreaDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            cityMap.put(city, pvo);
                        } else {
                            AreaDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            cityMap.put(city, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<AreaDataVO>(cityMap.values());
                    Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
                    for (AreaDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                            dataVO.setInfoAreaVOS(projectCountVOS);
                        }
                    }
                }

            } else {//不同省份
                rangeType = "China";
                Map<String, AreaDataVO> provinceMap = new HashMap<>();
                for (InfoAreaVO vo : infoAreaVOS) {
                    String province = vo.getProvince();
                    if (!provinceMap.containsKey(province)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        provinceMap.put(province, pvo);
                    } else {
                        AreaDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue() + 1);
                        provinceMap.put(province, projectDataVO);
                    }
                }
                Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getProvince));
                dataVOS = new ArrayList<AreaDataVO>(provinceMap.values());
                for (AreaDataVO dataVO : dataVOS) {
                    if (map.containsKey(dataVO.getName())) {
                        List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                        dataVO.setInfoAreaVOS(projectCountVOS);
                    }
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<AreaDataVO>() {
                @Override
                public int compare(AreaDataVO o1, AreaDataVO o2) {
                    int a = "其他".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "其他".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        //在这个地方处理四个直辖市
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        if (rangeType == null || rangeType.contains("null")) {
            rangeType = "China";
        }
        jsonObject.put("range", rangeType == null || rangeType.contains("null") ? "China" : rangeType);
        List<AreaDataVO> projectDataVOS = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(dataVOS)) {
//            Map<String, AreaDataVO> map = dataVOS.stream().collect(Collectors.toMap(k -> k.getName(), (k) -> k));
//            if (rangeType.equals("China")) {
//                //河南的省 省内
//                if (map.containsKey("河南省")) {
//                    List<InfoAreaVO> projectList = new ArrayList<>();
//                    AreaDataVO vo = map.get("河南省");
//                    if (vo != null) {
//                        projectList.addAll(vo.getInfoAreaVOS());
//                    }
//                    List<Long> areaInfoIds = projectList.stream().map(InfoAreaVO::getId).collect(Collectors.toList());
//
//                    AreaDataVO projectDataVO = new AreaDataVO();
//                    projectDataVO.setCurrentProvince("河南省");
//                    projectDataVO.setName("省内");
//                    projectDataVO.setValue(areaInfoIds.size());
//                    projectDataVOS.add(projectDataVO);
//                }
//
//                //河南省的 省外 排除其他的
//                List<Long> projectIds = new ArrayList<>();
//                for (AreaDataVO dataVO : dataVOS) {
//                    if (!"其他".equals(dataVO.getName()) && !"河南省".equals(dataVO.getName())) {
//                        List<Long> pids = dataVO.getInfoAreaVOS().stream().map(InfoAreaVO::getId).collect(Collectors.toList());
//                        projectIds.addAll(pids);
//                    }
//                }
//
//                AreaDataVO projectDataVO = new AreaDataVO();
//                projectDataVO.setName("省外");
//                projectDataVO.setValue(projectIds.size());
//                projectDataVOS.add(projectDataVO);
//                jsonObject.put("data", projectDataVOS);
//                return CommonResponse.success("查询数据成功！", jsonObject);
//            }
//        }
        jsonObject.put("data", dataVOS);
        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    private List<AreaDataVO> projectCountByName(String name, List<InfoAreaVO> list, Integer type) {
        List<AreaDataVO> dataVOS = new ArrayList<>();
        Map<String, AreaDataVO> map = new HashMap<>();
        for (InfoAreaVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (voName.equals(name)) {
                if (!map.containsKey(childrenName)) {
                    AreaDataVO pvo = new AreaDataVO();
                    pvo.setName(childrenName);
                    pvo.setValue(1);
                    map.put(childrenName, pvo);
                } else {
                    AreaDataVO projectDataVO = map.get(childrenName);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    map.put(childrenName, projectDataVO);
                }
            }
        }
        Map<String, List<InfoAreaVO>> projectCountVOMap = null;
        if (type == 0) {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
        } else {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
        }
        ArrayList<AreaDataVO> projectDataVOS = new ArrayList<>(map.values());
        for (AreaDataVO dataVO : projectDataVOS) {
            if (map.containsKey(dataVO.getName())) {
                List<InfoAreaVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
                dataVO.setInfoAreaVOS(projectCountVOS);
            }
        }
        return projectDataVOS;

    }


}
