package com.ejianc.business.guarantee.letter.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.guarantee.letter.mapper.GuaranteeLetterMapper;
import com.ejianc.business.guarantee.letter.bean.GuaranteeLetterEntity;
import com.ejianc.business.guarantee.letter.service.IGuaranteeLetterService;

import java.util.Arrays;
import java.util.List;

/**
 * 保函生成
 * 
 * @author generator
 * 
 */
@Service("guaranteeLetterService")
public class GuaranteeLetterServiceImpl extends BaseServiceImpl<GuaranteeLetterMapper, GuaranteeLetterEntity> implements IGuaranteeLetterService{
    @Override
    public List<GuaranteeLetterEntity> getListByConId(Long contractId) {
        return this.list(Wrappers.<GuaranteeLetterEntity>lambdaQuery()
                .eq(GuaranteeLetterEntity::getContractId, contractId)
                .in(GuaranteeLetterEntity::getBillState, Arrays.asList(1, 3))
        );
    }
}
