package com.ejianc.business.guarantee.relieve.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.guarantee.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.guarantee.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.guarantee.relieve.service.IContractRelieveService;

import java.util.Arrays;
import java.util.List;

/**
 * 担保合同解保
 * 
 * @author generator
 * 
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService{
    @Override
    public List<ContractRelieveEntity> getListByConId(Long contractId) {
        return this.list(Wrappers.<ContractRelieveEntity>lambdaQuery()
                .eq(ContractRelieveEntity::getContractId, contractId)
                .in(ContractRelieveEntity::getBillState, Arrays.asList(1, 3))
        );
    }
}
