/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.guarantee.homePage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.bean.RecoveryEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalEntity;
import com.ejianc.business.guarantee.contract.service.IContractEndService;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contract.service.IRecoveryService;
import com.ejianc.business.guarantee.contract.service.IRenewalService;
import com.ejianc.business.guarantee.contract.vo.ContractVO;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.business.guarantee.homePage.service.IHomePageService;
import com.ejianc.business.guarantee.homePage.vo.ProjectBaseVO;
import com.ejianc.business.guarantee.homePage.vo.TypeVO;
import com.ejianc.business.guarantee.homePage.vo.areaVO.AreaDataVO;
import com.ejianc.business.guarantee.homePage.vo.areaVO.InfoAreaVO;
import com.ejianc.business.guarantee.letter.bean.GuaranteeLetterEntity;
import com.ejianc.business.guarantee.letter.service.IGuaranteeLetterService;
import com.ejianc.business.guarantee.projectReview.bean.ProjectReviewEntity;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewService;
import com.ejianc.business.guarantee.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.guarantee.relieve.service.IContractRelieveService;
import com.ejianc.business.guarantee.utils.AddressResolutionUtil;
import com.ejianc.business.guarantee.utils.EJCDateUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"homePage"})
public class HomePageController {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractRelieveService contractRelieveService;
    @Autowired
    private IRecoveryService recoveryService;
    @Autowired
    private IRenewalService renewalService;
    @Autowired
    private IGuaranteeLetterService guaranteeLetterService;
    @Autowired
    private IContractEndService contractEndService;
    @Autowired
    private IHomePageService service;
    @Autowired
    private IProjectReviewService projectReviewService;

    @RequestMapping(value={"/projectBase"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectBaseVO> RiskProjectBase() {
        ProjectBaseVO projectBaseVO = new ProjectBaseVO();
        Date date = new Date();
        String beginDate = DateFormatUtils.format((Date)DateUtil.beginOfYear((Date)date), (String)"yyyy-MM-dd");
        String endDate = DateFormatUtils.format((Date)DateUtil.endOfYear((Date)date), (String)"yyyy-MM-dd");
        List contractList = this.contractService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).in(ContractEntity::getBillState, Arrays.asList(1, 3))).gt(ContractEntity::getCommitDate, (Object)beginDate)).lt(ContractEntity::getCommitDate, (Object)endDate));
        List letterList = this.guaranteeLetterService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).in(GuaranteeLetterEntity::getBillState, Arrays.asList(1, 3))).gt(BaseEntity::getCreateTime, (Object)beginDate)).lt(BaseEntity::getCreateTime, (Object)endDate));
        long guaranteeNum = contractList.stream().filter(s -> ContractStatuesEnum.\u5728\u4fdd.getCode().equals(s.getContractStatus())).count();
        List relieveList = this.contractRelieveService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).in(ContractRelieveEntity::getBillState, Arrays.asList(1, 3))).gt(BaseEntity::getCreateTime, (Object)beginDate)).lt(BaseEntity::getCreateTime, (Object)endDate));
        List recoveryList = this.recoveryService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).in(RecoveryEntity::getBillState, Arrays.asList(1, 3))).gt(BaseEntity::getCreateTime, (Object)beginDate)).lt(BaseEntity::getCreateTime, (Object)endDate));
        List renewalList = this.renewalService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).in(RenewalEntity::getBillState, Arrays.asList(1, 3))).gt(BaseEntity::getCreateTime, (Object)beginDate)).lt(BaseEntity::getCreateTime, (Object)endDate));
        projectBaseVO.setAddNum(Long.valueOf(letterList.size()));
        projectBaseVO.setGuaranteeNum(guaranteeNum);
        projectBaseVO.setRelieveNum(Long.valueOf(relieveList.size()));
        projectBaseVO.setRecoveryNum(Long.valueOf(recoveryList.size()));
        projectBaseVO.setRenewalNum(Long.valueOf(renewalList.size()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)projectBaseVO);
    }

    @RequestMapping(value={"/queryGuaranteeType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryGuaranteeType(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<TypeVO> typeVOS = this.service.queryGuaranteeType(wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u62c5\u4fdd\u7c7b\u578b\u5206\u5e03\u6570\u636e\u6210\u529f\uff01", typeVOS);
    }

    @RequestMapping(value={"/getInfoArea"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getInfoArea(@RequestParam(value="name", required=false) String name, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.infoArea(name, dateIn, orgId);
    }

    public CommonResponse<JSONObject> infoArea(String name, String dateIn, Long orgId) {
        Map<String, List<InfoAreaVO>> map;
        dateIn = EJCDateUtil.getYear() + "";
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)dateIn)) {
            queryWrapper.eq((Object)"DATE_FORMAT(letter_date,\"%Y\")", (Object)dateIn);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        queryWrapper.ne((Object)"contract_status", (Object)0);
        List list = this.contractService.list((Wrapper)queryWrapper);
        ArrayList<InfoAreaVO> infoAreaVOS = new ArrayList<InfoAreaVO>();
        if (ListUtil.isNotEmpty((List)list)) {
            List infoRegisterVOS = BeanMapper.mapList((Iterable)list, ContractVO.class);
            for (ContractVO infoRegisterVO : infoRegisterVOS) {
                InfoAreaVO infoAreaVO = new InfoAreaVO();
                infoAreaVO.setId(infoRegisterVO.getId());
                infoAreaVO.setOrgId(infoRegisterVO.getOrgId());
                infoAreaVO.setProjectName(infoRegisterVO.getProjectName());
                if (StringUtils.isNotEmpty((CharSequence)infoRegisterVO.getApplyAreaName())) {
                    String areaName = null;
                    areaName = infoRegisterVO.getApplyAreaName().replace("/", "");
                    infoAreaVO.setAreaName(areaName);
                } else {
                    infoAreaVO.setAreaName(infoRegisterVO.getApplyAreaName());
                }
                infoAreaVOS.add(infoAreaVO);
            }
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (InfoAreaVO vo : infoAreaVOS) {
            ids.add(vo.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getAreaName())) {
                if (vo.getAreaName().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMap = AddressResolutionUtil.addressResolution(vo.getAreaName());
                if (areaMap != null) {
                    String province = areaMap.get("province") == null ? "\u5176\u4ed6" : areaMap.get("province");
                    String string = areaMap.get("city") == null ? "\u5176\u4ed6" : areaMap.get("city");
                    String string2 = areaMap.get("county") == null ? "\u5176\u4ed6" : areaMap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pname = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, infoAreaVOS, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, infoAreaVOS, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, AreaDataVO> countyMap = new HashMap<String, AreaDataVO>();
                for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                    String string = infoAreaVO.getCounty();
                    if (!countyMap.containsKey(string)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(string);
                        pvo.setValue(1);
                        countyMap.put(string, pvo);
                        continue;
                    }
                    AreaDataVO projectDataVO = (AreaDataVO)countyMap.get(string);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
                for (AreaDataVO areaDataVO : dataVOS) {
                    if (!map.containsKey(areaDataVO.getName())) continue;
                    List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                    areaDataVO.setInfoAreaVOS(projectCountVOS);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, AreaDataVO> cityMap = new HashMap<String, AreaDataVO>();
                for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                    String string = infoAreaVO.getCity();
                    if (!cityMap.containsKey(string)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(string);
                        pvo.setValue(1);
                        cityMap.put(string, pvo);
                        continue;
                    }
                    AreaDataVO projectDataVO = (AreaDataVO)cityMap.get(string);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
                for (AreaDataVO areaDataVO : dataVOS) {
                    if (!map.containsKey(areaDataVO.getName())) continue;
                    List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                    areaDataVO.setInfoAreaVOS(projectCountVOS);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, AreaDataVO> provinceMap = new HashMap<String, AreaDataVO>();
            for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                String string = infoAreaVO.getProvince();
                if (!provinceMap.containsKey(string)) {
                    AreaDataVO pvo = new AreaDataVO();
                    pvo.setName(string);
                    pvo.setValue(1);
                    provinceMap.put(string, pvo);
                    continue;
                }
                AreaDataVO projectDataVO = (AreaDataVO)provinceMap.get(string);
                projectDataVO.setValue(projectDataVO.getValue() + 1);
                provinceMap.put(string, projectDataVO);
            }
            map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (AreaDataVO areaDataVO : dataVOS) {
                if (!map.containsKey(areaDataVO.getName())) continue;
                List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                areaDataVO.setInfoAreaVOS(projectCountVOS);
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<AreaDataVO>(){

                @Override
                public int compare(AreaDataVO o1, AreaDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        if (rangeType == null || rangeType.contains("null")) {
            rangeType = "China";
        }
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        ArrayList projectDataVOS = new ArrayList();
        jsonObject.put("data", dataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<AreaDataVO> projectCountByName(String name, List<InfoAreaVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, AreaDataVO> map = new HashMap<String, AreaDataVO>();
        for (InfoAreaVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            if (!map.containsKey(childrenName)) {
                AreaDataVO pvo = new AreaDataVO();
                pvo.setName(childrenName);
                pvo.setValue(1);
                map.put(childrenName, pvo);
                continue;
            }
            AreaDataVO projectDataVO = (AreaDataVO)map.get(childrenName);
            projectDataVO.setValue(projectDataVO.getValue() + 1);
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<InfoAreaVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity)) : list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
        ArrayList<AreaDataVO> projectDataVOS = new ArrayList<AreaDataVO>(map.values());
        for (AreaDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<InfoAreaVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            dataVO.setInfoAreaVOS(projectCountVOS);
        }
        return projectDataVOS;
    }

    @RequestMapping(value={"/getInfoRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> getInfoRank(@RequestBody QueryParam param) {
        String type = "1";
        if (param.getParams().get("type") != null) {
            type = ((Parameter)param.getParams().get("type")).getValue().toString();
            param.getParams().remove("type");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List list = this.contractService.list((Wrapper)wrapper);
        for (ContractEntity contractEntity : list) {
            String applyAreaName;
            String[] split;
            if (contractEntity.getApplyAreaName() == null || (split = (applyAreaName = contractEntity.getApplyAreaName()).split("/")).length <= 1) continue;
            contractEntity.setApplyAreaName(split[1]);
        }
        List<Object> resultJSON = new ArrayList();
        switch (type) {
            case "1": {
                Map<String, Long> areaMap1 = list.stream().collect(Collectors.groupingBy(ContractEntity::getApplyAreaName, Collectors.counting()));
                resultJSON = HomePageController.longSortMap(areaMap1);
                break;
            }
            case "2": {
                Map<String, BigDecimal> areaMap2 = list.stream().filter(s -> s.getBaseTaxMny() != null).collect(Collectors.groupingBy(ContractEntity::getApplyAreaName, Collectors.reducing(BigDecimal.ZERO, ContractEntity::getBaseTaxMny, BigDecimal::add)));
                resultJSON = HomePageController.bigDecimalSortMap(areaMap2);
                break;
            }
            case "3": {
                Map<String, BigDecimal> areaMap3 = list.stream().filter(s -> s.getBasePremiumTaxMny() != null).collect(Collectors.groupingBy(ContractEntity::getApplyAreaName, Collectors.reducing(BigDecimal.ZERO, ContractEntity::getBasePremiumTaxMny, BigDecimal::add)));
                resultJSON = HomePageController.bigDecimalSortMap(areaMap3);
                break;
            }
            case "4": {
                Map<String, BigDecimal> areaMap4 = list.stream().filter(s -> s.getReturnTaxBond() != null).collect(Collectors.groupingBy(ContractEntity::getApplyAreaName, Collectors.reducing(BigDecimal.ZERO, ContractEntity::getReturnTaxBond, BigDecimal::add)));
                resultJSON = HomePageController.bigDecimalSortMap(areaMap4);
                break;
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5730\u533a\u6392\u540d\u6570\u636e\u6210\u529f\uff01", resultJSON);
    }

    private static List<JSONObject> longSortMap(Map<String, Long> map) {
        ArrayList<Map.Entry<String, Long>> entryList = new ArrayList<Map.Entry<String, Long>>(map.entrySet());
        entryList.sort(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return (int)(o2.getValue() - o1.getValue());
            }
        });
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (Map.Entry entry : entryList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", entry.getKey());
            jsonObject.put("value", entry.getValue());
            jsonObjects.add(jsonObject);
        }
        return jsonObjects;
    }

    private static List<JSONObject> bigDecimalSortMap(Map<String, BigDecimal> map) {
        ArrayList<Map.Entry<String, BigDecimal>> entryList = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        entryList.sort(new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (Map.Entry entry : entryList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", entry.getKey());
            jsonObject.put("value", entry.getValue());
            jsonObjects.add(jsonObject);
        }
        return jsonObjects;
    }

    @RequestMapping(value={"/getGuaranteeProjectType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> getGuaranteeProjectType(@RequestBody QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List list = this.projectReviewService.list((Wrapper)wrapper);
        for (ProjectReviewEntity entity : list) {
            if (entity.getBillState() == 5) {
                entity.setBillState(2);
            }
            if (entity.getBillState() != 6) continue;
            entity.setBillState(4);
        }
        Map<Integer, Long> collect = list.stream().collect(Collectors.groupingBy(ProjectReviewEntity::getBillState, Collectors.counting()));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (Map.Entry<Integer, Long> entry : collect.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            switch (entry.getKey()) {
                case 0: {
                    jsonObject.put("name", (Object)"\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    jsonObject.put("name", (Object)"\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    jsonObject.put("name", (Object)"\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    jsonObject.put("name", (Object)"\u5df2\u901a\u8fc7");
                    break;
                }
                case 4: {
                    jsonObject.put("name", (Object)"\u5df2\u9a73\u56de");
                }
            }
            jsonObject.put("value", (Object)entry.getValue());
            jsonObjects.add(jsonObject);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5730\u533a\u6392\u540d\u6570\u636e\u6210\u529f\uff01", jsonObjects);
    }

    @RequestMapping(value={"/getGuaranteeStatusType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> getGuaranteeStatusType(@RequestBody QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List list = this.contractService.list((Wrapper)wrapper);
        Map<Integer, Long> collect = list.stream().collect(Collectors.groupingBy(ContractEntity::getContractStatus, Collectors.counting()));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (Map.Entry<Integer, Long> entry : collect.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            switch (entry.getKey()) {
                case 0: {
                    jsonObject.put("name", (Object)"\u7b7e\u8ba2\u4e2d");
                    break;
                }
                case 1: {
                    jsonObject.put("name", (Object)"\u5728\u4fdd");
                    break;
                }
                case 2: {
                    jsonObject.put("name", (Object)"\u89e3\u4fdd");
                    break;
                }
                case 3: {
                    jsonObject.put("name", (Object)"\u5df2\u7ed3\u675f");
                    break;
                }
                case 4: {
                    jsonObject.put("name", (Object)"\u5df2\u5173\u95ed");
                    break;
                }
                case 5: {
                    jsonObject.put("name", (Object)"\u5df2\u8fc7\u671f");
                }
            }
            jsonObject.put("code", (Object)entry.getKey());
            jsonObject.put("value", (Object)entry.getValue());
            jsonObjects.add(jsonObject);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5730\u533a\u6392\u540d\u6570\u636e\u6210\u529f\uff01", jsonObjects);
    }
}

