package com.ejianc.business.guarantee.contract.service.impl;

import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.business.guarantee.enums.ProjectReviewStatuesEnum;
import com.ejianc.business.guarantee.projectReview.bean.ProjectReviewEntity;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("contract") 
public class ContractBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractService service;

	@Autowired
	private IProjectReviewService projectReviewService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		logger.info("提交前！");
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		ContractEntity contractEntity = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		//设置单据提交人信息
		contractEntity.setCommitDate(new Date());
		contractEntity.setCommitUserCode(userContext.getUserCode());
		contractEntity.setCommitUserName(userContext.getUserName());
		//更改合同状态为签订中
		contractEntity.setContractStatus(ContractStatuesEnum.签订中.getCode());
		service.saveOrUpdate(contractEntity);
		logger.info("合同回调处理成功，已更改合同状态为签订中！code={}",ContractStatuesEnum.签订中.getCode());

		ProjectReviewEntity projectReviewEntity = projectReviewService.selectById(contractEntity.getProjectId());
		if(projectReviewEntity != null){
			projectReviewEntity.setFollowStatus(ProjectReviewStatuesEnum.评审中.getCode());
			projectReviewService.saveOrUpdate(projectReviewEntity);
			logger.info("项目评审回调处理成功，已更改跟踪状态为评审中！");
			return CommonResponse.success("合同回调处理成功，已更改合同状态为签订中！");
		} else {
			return CommonResponse.error("项目评审跟踪状态回调失败，projectId为空！");

		}
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ContractEntity contractEntity = service.selectById(billId);

		if(contractEntity.getProjectId() != null){
			ProjectReviewEntity projectReviewEntity = projectReviewService.selectById(contractEntity.getProjectId());
			if(projectReviewEntity != null){
				projectReviewEntity.setFollowStatus(ProjectReviewStatuesEnum.评审结束.getCode());
				projectReviewService.saveOrUpdate(projectReviewEntity);
				logger.info("项目评审回调处理成功，已更改跟踪状态为评审结束！");

				contractEntity.setApproveDate(new Date());
				contractEntity.setProjectApproveDate(projectReviewEntity.getApproveDate());
				contractEntity.setProjectCreateDate(projectReviewEntity.getCreateTime());

				return CommonResponse.success("项目评审回调处理成功，已更改跟踪状态为评审结束！");
			}

		}
		return CommonResponse.error("合同评审回调失败！根据projectId查询所选项目不存在！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
