package com.ejianc.business.guarantee.contractChange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.guarantee.contract.bean.ContractDetailEntity;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.bean.ContractInfoEntity;
import com.ejianc.business.guarantee.contract.service.IContractDetailService;
import com.ejianc.business.guarantee.contract.service.IContractInfoService;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contractChange.bean.ContractChangeDetailEntity;
import com.ejianc.business.guarantee.contractChange.bean.ContractChangeEntity;
import com.ejianc.business.guarantee.contractChange.bean.ContractChangeInfoEntity;
import com.ejianc.business.guarantee.contractChange.bean.ContractHistoryEntity;
import com.ejianc.business.guarantee.contractChange.service.IContractChangeService;
import com.ejianc.business.guarantee.contractChange.service.IContractHistoryService;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("contractChange") 
public class ContractChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractHistoryService historyService;
	@Autowired
	private IContractService contractService;
	@Autowired
	private IContractChangeService contractChangeService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IContractInfoService contractInfoService;
	@Autowired
	private IContractDetailService contractDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//
		logger.info("合同变更开始---------------------");
		ContractChangeEntity contractChangeEntity = contractChangeService.selectById(billId);
		if(null != contractChangeEntity){
			ContractEntity contractEntity = contractService.selectById(contractChangeEntity.getOldReviewId());
			if(null != contractEntity){
				//1.将原合同保存到变更历史
				ContractHistoryEntity contractHistoryEntity = BeanMapper.map(contractEntity, ContractHistoryEntity.class);
				contractHistoryEntity.setOldReviewId(contractEntity.getId());
				contractHistoryEntity.setId(null);
				historyService.saveOrUpdate(contractHistoryEntity);

				//2.将变更单据回写到原合同

				//2.1初始化合同状态
				contractEntity.setContractStatus(ContractStatuesEnum.签订中.getCode());
				contractEntity.setFinanceStatus(null);//财务到账信息状态
				contractEntity.setLetterDate(null);//出函时间
				contractEntity.setChangeStatus(ContractStatuesEnum.已变更.getCode());

				//2.2合同信息
				contractEntity.setChangeCode(contractChangeEntity.getBillCode());
				contractEntity.setSelfCode(contractChangeEntity.getSelfCode());
				contractEntity.setProjectId(contractChangeEntity.getProjectId());
				contractEntity.setProjectName(contractChangeEntity.getProjectName());
				contractEntity.setContractName(contractChangeEntity.getContractName());
				contractEntity.setApplyArea(contractChangeEntity.getApplyArea());
				contractEntity.setApplyAreaName(contractChangeEntity.getApplyAreaName());
				contractEntity.setEmployeeId(contractChangeEntity.getEmployeeId());
				contractEntity.setEmployeeName(contractChangeEntity.getEmployeeName());
				contractEntity.setProjectAddress(contractChangeEntity.getProjectAddress());
				contractEntity.setStartDate(contractChangeEntity.getStartDate());
				contractEntity.setEndDate(contractChangeEntity.getEndDate());
				contractEntity.setDuration(contractChangeEntity.getDuration());
				contractEntity.setContractTaxMny(contractChangeEntity.getContractTaxMny());
				contractEntity.setOwner(contractChangeEntity.getOwner());
				contractEntity.setOwnerName(contractChangeEntity.getOwnerName());
				contractEntity.setContractorId(contractChangeEntity.getContractorId());
				contractEntity.setContractName(contractChangeEntity.getContractName());
				contractEntity.setProjectType(contractChangeEntity.getProjectType());
				contractEntity.setProjectTypeName(contractChangeEntity.getProjectTypeName());
				contractEntity.setConstructProcedure(contractChangeEntity.getConstructProcedure());
				contractEntity.setSourceFunds(contractChangeEntity.getSourceFunds());
				contractEntity.setSourceFundsName(contractChangeEntity.getSourceFundsName());
				contractEntity.setApplicant(contractChangeEntity.getApplicant());
				contractEntity.setApplyAreaName(contractChangeEntity.getApplyAreaName());
				contractEntity.setRegisterMny(contractChangeEntity.getRegisterMny());
				contractEntity.setLitigationCases(contractChangeEntity.getLitigationCases());
				contractEntity.setLegalPersonName(contractChangeEntity.getLegalPersonName());
				contractEntity.setEstablishDate(contractChangeEntity.getEstablishDate());
				contractEntity.setQualityLevelName(contractChangeEntity.getQualityLevelName());
				contractEntity.setClient(contractChangeEntity.getClient());
				contractEntity.setClientName(contractChangeEntity.getClientName());
				contractEntity.setClientPhone(contractChangeEntity.getClientPhone());
				contractEntity.setLitigationAddress(contractChangeEntity.getLitigationAddress());
				contractEntity.setLitigationAddressName(contractChangeEntity.getLitigationAddressName());
				contractEntity.setEnsureDuty(contractChangeEntity.getEnsureDuty());
				contractEntity.setEnsureDutyName(contractChangeEntity.getEnsureDutyName());
				contractEntity.setBaseTaxMny(contractChangeEntity.getBaseTaxMny());
				contractEntity.setGuaranteeMnyPer(contractChangeEntity.getGuaranteeMnyPer());
				contractEntity.setBasePremiumTaxMny(contractChangeEntity.getBasePremiumTaxMny());
				contractEntity.setGuaranteeEffectDate(contractChangeEntity.getGuaranteeEffectDate());
				contractEntity.setGuaranteeTermEndDate(contractChangeEntity.getGuaranteeTermEndDate());
				contractEntity.setGuaranteeTermStartDate(contractChangeEntity.getGuaranteeTermStartDate());
				contractEntity.setReturnTaxBond(contractChangeEntity.getReturnTaxBond());

				//2.3子表信息
				for (ContractChangeDetailEntity contractChangeDetailEntity : contractChangeEntity.getContractChangeDetailList()) {
					contractChangeDetailEntity.setContractId(contractEntity.getId());
					contractChangeDetailEntity.setCreateTime(new Date());
					contractChangeDetailEntity.setUpdateTime(null);
					ContractDetailEntity contractDetail = BeanMapper.map(contractChangeDetailEntity, ContractDetailEntity.class);
					contractDetailService.saveOrUpdate(contractDetail);

				}
				for (ContractChangeInfoEntity contractChangeInfoEntity : contractChangeEntity.getContractChangeInfoList()) {
					contractChangeInfoEntity.setContractId(contractEntity.getId());
					contractChangeInfoEntity.setCreateTime(new Date());
					contractChangeInfoEntity.setUpdateTime(null);
					ContractInfoEntity contractInfoEntity = BeanMapper.map(contractChangeInfoEntity, ContractInfoEntity.class);
					contractInfoService.saveOrUpdate(contractInfoEntity);
				}
				contractService.saveOrUpdate(contractEntity);
				logger.info("更改原合同数据成功！--------{}",contractEntity);




				//3.同步附件
				logger.info("原合同同步附件");
				//3.1将原合同附件同步到记录表中
				CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(contractEntity.getId()), "ZZYJ202303230003", "guaranteeContractFile",
						String.valueOf(contractEntity.getId()), "ZZYJ202305160002", "historyFile");
				logger.info("原合同合同同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());
				//3.2将变更合同附件同步到原合同汇总
				logger.info("变更合同同步附件");
				CommonResponse<String> changeResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(contractChangeEntity.getId()), "ZZYJ202305100001", "contractChangeFile",
						String.valueOf(contractEntity.getId()), "ZZYJ202303230003", "guaranteeContractFile");
				logger.info("变更合同同步附件::::::::::::结果::" + JSONObject.toJSONString(changeResponse).toString());


				logger.info("合同变更结束------------------------");
				return CommonResponse.success("合同变更成功！");
			}
			logger.info("根据id查询原合同为空--------{}",contractChangeEntity.getOldReviewId());
		}
		logger.info("根据id查询变更历史为空--------{}",billId);
		return CommonResponse.error("系统错误！查找不到该单据！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	/**
	 * @Author Jiang
	 * @Date 2023年5月10日16:10:44
	 *
	 * @Descript 模拟提交后的过程
	 *
	 *      1.将原合同保存到变更历史
	 *      2.将变更单据回写到原合同
	 *      3.附件回写
	 *
	 */
}
