/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.guarantee.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalFinanceEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contract.service.IFinanceService;
import com.ejianc.business.guarantee.contract.service.IRenewalFinanceService;
import com.ejianc.business.guarantee.contract.service.IRenewalService;
import com.ejianc.business.guarantee.contract.vo.ContractVO;
import com.ejianc.business.guarantee.contract.vo.TotalFinanceVO;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.business.guarantee.letter.bean.GuaranteeLetterEntity;
import com.ejianc.business.guarantee.letter.service.IGuaranteeLetterService;
import com.ejianc.business.guarantee.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.guarantee.relieve.service.IContractRelieveService;
import com.ejianc.business.guarantee.upload.bean.UploadInfoEntity;
import com.ejianc.business.guarantee.upload.service.IUploadInfoService;
import com.ejianc.business.guarantee.utils.HttpClientUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.Subdivision;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contract"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Guarantee_Contract";
    @Autowired
    private IContractService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFinanceService financeService;
    @Autowired
    private IUploadInfoService uploadInfoService;
    @Autowired
    private IRenewalService renewalService;
    @Autowired
    private IRenewalFinanceService renewalFinanceService;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IGuaranteeLetterService letterService;
    @Autowired
    private IRoleApi roleApi;
    private static final Long roleId = 743489009428344920L;
    private final String Guarantee_Bill_CODE = "ZZYJ202303230003";
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveOrUpdateVO) {
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setRenewalDate(entity.getGuaranteeTermEndDate());
        System.out.println(ContractStatuesEnum.\u7b7e\u8ba2\u4e2d.getCode());
        this.service.saveOrUpdate((Object)entity, false);
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.service.selectById(id));
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractVO contractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List roleVOS;
        long count;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("selfCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("applyAreaName");
        fuzzyFields.add("applicantName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("ownerName");
        fuzzyFields.add("contractorName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        CommonResponse listCommonResponse = this.roleApi.queryRoleByUserId(userContextCache.getUserId());
        if (listCommonResponse.isSuccess() && (count = (roleVOS = (List)listCommonResponse.getData()).stream().filter(s -> s.getId().equals(roleId)).count()) != 0L) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)userContextCache.getUserCode()));
        }
        IPage page = this.service.queryPage(param, false);
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal totalPremiumTaxMny = BigDecimal.ZERO;
        BigDecimal totalGuaranteeReturnTaxMny = BigDecimal.ZERO;
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"dr", (Object)0);
        List<ContractVO> contractVOS = this.service.queryContractSumMny(wrapper);
        if (ListUtil.isNotEmpty(contractVOS)) {
            totalTaxMny = contractVOS.get(0).getBaseTaxMny();
            totalPremiumTaxMny = contractVOS.get(0).getBasePremiumTaxMny();
            totalGuaranteeReturnTaxMny = contractVOS.get(0).getGuaranteeReturnTaxMny();
        }
        JSONObject pageData = new JSONObject();
        pageData.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        pageData.put("total", (Object)page.getTotal());
        pageData.put("current", (Object)page.getCurrent());
        pageData.put("size", (Object)page.getSize());
        pageData.put("pages", (Object)page.getPages());
        pageData.put("totalTaxMny", (Object)totalTaxMny);
        pageData.put("totalPremiumTaxMny", (Object)totalPremiumTaxMny);
        pageData.put("totalGuaranteeReturnTaxMny", (Object)totalGuaranteeReturnTaxMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List roleVOS;
        long count;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("selfCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("applyAreaName");
        fuzzyFields.add("applicantName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("ownerName");
        fuzzyFields.add("contractorName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = this.sessionManager.getUserContext();
        CommonResponse listCommonResponse = this.roleApi.queryRoleByUserId(userContextCache.getUserId());
        if (listCommonResponse.isSuccess() && (count = (roleVOS = (List)listCommonResponse.getData()).stream().filter(s -> s.getId().equals(roleId)).count()) != 0L) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)userContextCache.getUserCode()));
        }
        List list = this.service.queryList(param);
        List contractVOS = BeanMapper.mapList((Iterable)list, ContractVO.class);
        for (ContractVO contractVO : contractVOS) {
            List<ContractRelieveEntity> relieveEntities;
            List<RenewalEntity> renewalEntities;
            Long contractId = contractVO.getId();
            List<GuaranteeLetterEntity> letterEntityList = this.letterService.getListByConId(contractId);
            if (ListUtil.isNotEmpty(letterEntityList)) {
                Integer isOnline = letterEntityList.get(0).getIsOnline();
                if (isOnline != null && isOnline == 1) {
                    contractVO.setIsOnlineName("\u4e0a\u7f51");
                } else if (isOnline != null && isOnline == 2) {
                    contractVO.setIsOnlineName("\u672a\u4e0a\u7f51");
                }
            }
            if (ListUtil.isNotEmpty(renewalEntities = this.renewalService.getListByConId(contractId))) {
                BigDecimal totalMny = BigDecimal.ZERO;
                for (RenewalEntity renewalEntity : renewalEntities) {
                    if (renewalEntity.getPremiumTaxMny() == null) continue;
                    totalMny = totalMny.add(renewalEntity.getPremiumTaxMny());
                }
                contractVO.setRenewalPremiumTaxMny(totalMny);
            }
            if (!ListUtil.isNotEmpty(relieveEntities = this.relieveService.getListByConId(contractId))) continue;
            BigDecimal totalMny = BigDecimal.ZERO;
            for (ContractRelieveEntity relieveEntity : relieveEntities) {
                if (relieveEntity.getPremiumTaxMny() == null) continue;
                totalMny = totalMny.add(relieveEntity.getPremiumTaxMny());
            }
            contractVO.setRelievePremiumTaxMny(totalMny);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", contractVOS);
        ExcelExport.getInstance().export("Contract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List roleVOS;
        long count;
        UserContext userContextCache;
        CommonResponse listCommonResponse;
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getOrderMap().put("createTime", "desc");
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("serviceStatus")) {
            Integer serviceStatus = Integer.valueOf(conditionMap.get("serviceStatus").toString());
            if (1 == serviceStatus || 2 == serviceStatus || 3 == serviceStatus) {
                param.getParams().put("contractStatus", new Parameter("not_in", Arrays.asList(0, 3, 4)));
                param.getParams().put("recoveryStatus", new Parameter("eq", null));
                param.getParams().put("renewalStatus", new Parameter("eq", null));
            }
            if (4 == serviceStatus) {
                param.getParams().put("contractStatus", new Parameter("not_in", Arrays.asList(0, 3, 4)));
                param.getParams().put("recoveryStatus", new Parameter("eq", null));
            }
        }
        if ((listCommonResponse = this.roleApi.queryRoleByUserId((userContextCache = this.sessionManager.getUserContext()).getUserId())).isSuccess() && (count = (roleVOS = (List)listCommonResponse.getData()).stream().filter(s -> s.getId().equals(roleId)).count()) != 0L) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)userContextCache.getUserCode()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryHistoryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryHistoryList(@RequestBody QueryParam param) {
        Long id = Long.parseLong(((Parameter)param.getParams().get("oldReviewId")).getValue().toString());
        ArrayList<ContractEntity> list = new ArrayList<ContractEntity>();
        while (id != null) {
            id = this.getContract(id, list);
        }
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        page.setRecords(list);
        page.setTotal((long)list.size());
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Long getContract(Long id, List<ContractEntity> list) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        list.add(contractEntity);
        return contractEntity.getOldReviewId();
    }

    @RequestMapping(value={"/queryFinanceTotal"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TotalFinanceVO>> queryFinanceTotal(Long contractId) {
        List renewalFinanceEntities;
        ArrayList totalFinanceVOS = new ArrayList();
        List uploadInfoEntities = this.uploadInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).eq(UploadInfoEntity::getContractId, (Object)contractId)).in(UploadInfoEntity::getBillState, Arrays.asList(1, 3)));
        List renewalEntities = this.renewalService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).eq(RenewalEntity::getContractId, (Object)contractId));
        List renewalIds = renewalEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(renewalIds) && ListUtil.isNotEmpty((List)(renewalFinanceEntities = this.renewalFinanceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).in(RenewalFinanceEntity::getBillState, Arrays.asList(1, 3))).in(RenewalFinanceEntity::getRenewalId, renewalIds))))) {
            List renewalFinanceVOS = BeanMapper.mapList((Iterable)renewalFinanceEntities, TotalFinanceVO.class);
            totalFinanceVOS.addAll(renewalFinanceVOS);
        }
        if (ListUtil.isNotEmpty((List)uploadInfoEntities)) {
            List financeVOS = BeanMapper.mapList((Iterable)uploadInfoEntities, TotalFinanceVO.class);
            totalFinanceVOS.addAll(financeVOS);
        }
        if (ListUtil.isNotEmpty(totalFinanceVOS)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", totalFinanceVOS);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a!");
    }

    @RequestMapping(value={"/queryAddressByIP"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryAddressByIP(HttpServletRequest request) {
        String ipAddress = ContractController.getIpAddress(request);
        String address = ContractController.getRealAddress(ipAddress);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)address);
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.indexOf(",") != -1) {
            ip = ip.substring(0, ip.indexOf(",")).trim();
        }
        return ip;
    }

    public static String getRealAddress(String ip) {
        String result = "";
        try {
            ClassPathResource resource = new ClassPathResource("GeoLite2-City.mmdb");
            DatabaseReader reader = new DatabaseReader.Builder(resource.getInputStream()).build();
            InetAddress inetAddress = InetAddress.getByName(ip);
            CityResponse response = reader.city(inetAddress);
            String country = (String)response.getCountry().getNames().get("ja");
            if (response.getSubdivisions().size() > 0) {
                String province = (String)((Subdivision)response.getSubdivisions().get(0)).getNames().get("zh-CN");
                String city = (String)response.getCity().getNames().get("zh-CN");
                city = city == null ? "" : city;
                result = country + province + city;
            } else {
                result = ContractController.getAlibaba(ip);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getAlibaba(String ip) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ip", ip);
        map.put("accessKey", "alibaba-inc");
        String result = HttpClientUtil.post("http://ip.taobao.com/outGetIpInfo", map);
        Map valueMap = (Map)JSONObject.parseObject((String)result, Map.class);
        if ("query success".equals(valueMap.get("msg"))) {
            Map dataMap = (Map)valueMap.get("data");
            String country = (String)dataMap.get("country");
            String region = (String)dataMap.get("region");
            String city = (String)dataMap.get("city");
            return country + region + city;
        }
        return "";
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractCategoryId(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        resp.put("contractBillTypeCode", (Object)"ZZYJ202303230003");
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

