package com.ejianc.poc.gyy.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 采购申请报告实体
 *
 * @author CJ
 * @Description: 采购申请报告实体
 * @date 2021/3/23 16:04
 */
@TableName(value = "ejc_gyypoc_purchase_bill")
public class PurchaseBillEntity extends BaseEntity {

    /**
     * 所属采购流程Id
     */
    @TableField(value = "purchase_process_id")
    private Long purchaseProcessId;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;


    /**
     * 采购需求单据编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 采购需求单据名称
     */
    @TableField(value = "bill_name")
    private String billName;

    /**
     * 软件名称
     */
    @TableField(value = "software_name")
    private String softwareName;

    /**
     * 预算费用（万元）
     */
    @TableField(value = "budget_amt")
    private BigDecimal budgetAmt;

    /**
     * 单据创建人Id
     */
    @TableField(value = "create_user_id")
    private Long createUserId;

    /**
     * 申请单位Id
     */
    @TableField(value = "apply_org_id")
    private Long applyOrgId;

    /**
     * 申请单位名称
     */
    @TableField(value = "apply_org_name")
    private String applyOrgName;

    /**
     * 软件采购的必要性
     */
    @TableField(value = "purchase_necessity")
    private String purchaseNecessity;

    /**
     * 软件功能
     */
    @TableField(value = "software_function_desc")
    private String softwareFunctionDesc;

    /**
     * 类似软件比较
     */
    @TableField(value = "likely_software_compare")
    private String likelySoftwareCompare;

    /**
     * 应用规划
     */
    @TableField(value = "application_planning")
    private String applicationPlanning;

    /**
     * 软件数量
     */
    @TableField(value = "software_num")
    private String softwareNum;

    /**
     * 预期效益
     */
    @TableField(value = "prospective_earnings")
    private String prospectiveEarnings;

    /**
     * 采购方式及理由
     */
    @TableField(value = "purchase_desc")
    private String purchaseDesc;

    @TableField(exist = false)
    @SubEntity(serviceName = "softwareNeedsListService", pidName = "purchaseBillId")
    private List<SoftwareNeedsListEntity> softwareNeedsList;

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getPurchaseProcessId() {
        return purchaseProcessId;
    }

    public void setPurchaseProcessId(Long purchaseProcessId) {
        this.purchaseProcessId = purchaseProcessId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }

    public String getSoftwareName() {
        return softwareName;
    }

    public void setSoftwareName(String softwareName) {
        this.softwareName = softwareName;
    }

    public BigDecimal getBudgetAmt() {
        return budgetAmt;
    }

    public void setBudgetAmt(BigDecimal budgetAmt) {
        this.budgetAmt = budgetAmt;
    }

    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public String getPurchaseNecessity() {
        return purchaseNecessity;
    }

    public void setPurchaseNecessity(String purchaseNecessity) {
        this.purchaseNecessity = purchaseNecessity;
    }

    public String getSoftwareFunctionDesc() {
        return softwareFunctionDesc;
    }

    public void setSoftwareFunctionDesc(String softwareFunctionDesc) {
        this.softwareFunctionDesc = softwareFunctionDesc;
    }

    public String getLikelySoftwareCompare() {
        return likelySoftwareCompare;
    }

    public void setLikelySoftwareCompare(String likelySoftwareCompare) {
        this.likelySoftwareCompare = likelySoftwareCompare;
    }

    public String getApplicationPlanning() {
        return applicationPlanning;
    }

    public void setApplicationPlanning(String applicationPlanning) {
        this.applicationPlanning = applicationPlanning;
    }

    public String getSoftwareNum() {
        return softwareNum;
    }

    public void setSoftwareNum(String softwareNum) {
        this.softwareNum = softwareNum;
    }

    public String getProspectiveEarnings() {
        return prospectiveEarnings;
    }

    public void setProspectiveEarnings(String prospectiveEarnings) {
        this.prospectiveEarnings = prospectiveEarnings;
    }

    public String getPurchaseDesc() {
        return purchaseDesc;
    }

    public void setPurchaseDesc(String purchaseDesc) {
        this.purchaseDesc = purchaseDesc;
    }

    public List<SoftwareNeedsListEntity> getSoftwareNeedsList() {
        return softwareNeedsList;
    }

    public void setSoftwareNeedsList(List<SoftwareNeedsListEntity> softwareNeedsList) {
        this.softwareNeedsList = softwareNeedsList;
    }
}
