package com.ejianc.poc.gyy.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.gyypoc.vo.PurchaseBillVO;
import com.ejianc.business.gyypoc.vo.SoftwareNeedsListVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.poc.gyy.bean.PurchaseBillEntity;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.service.IPurchaseBillService;
import com.ejianc.poc.gyy.service.IPurchaseProcessService;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/23 17:09
 */
@RestController
@RequestMapping(value = "/purchaseBill/")
public class PurhcaseBillController {

    @Autowired
    private IPurchaseBillService purchaseBillService;

    @Autowired
    private IPurchaseProcessService purchaseProcessService;

    @Autowired
    private ISoftwareNeedsListService softwareNeedsListService;

    @Autowired
    private IBillCodeApi billCodeApi;

    private final String BILL_CODE = "GYYPOC_PURCHASE_BILL";

    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value = "saveOrUpdate")
    public CommonResponse<PurchaseBillVO> saveOrUpdate(@RequestBody PurchaseBillVO purchaseBillVO) {
        PurchaseBillEntity saveEntity = BeanMapper.map(purchaseBillVO, PurchaseBillEntity.class);
        UserContext userContext = sessionManager.getUserContext();

        if(StringUtils.isBlank(saveEntity.getBillCode())) {
            CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            saveEntity.setBillCode(codeResp.getData());
        }
        if(CollectionUtils.isNotEmpty(saveEntity.getSoftwareNeedsList())) {
            for(SoftwareNeedsListEntity soft : saveEntity.getSoftwareNeedsList()) {
                soft.setPurchaseBillCode(saveEntity.getBillCode());
            }
        }

        if(null != purchaseBillVO.getId()) {
            PurchaseBillEntity dbEntity = purchaseBillService.selectById(purchaseBillVO.getId());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setSyncEsFlag(dbEntity.getSyncEsFlag());
            saveEntity.setBillState(dbEntity.getBillState());
            saveEntity.setPurchaseProcessId(dbEntity.getPurchaseProcessId());
            saveEntity.setTenantId(dbEntity.getTenantId());
            saveEntity.setDr(dbEntity.getDr());

        } else {
            //设置编制人
            saveEntity.setCreateUserName(userContext.getUserName());
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserId(userContext.getUserId());
        }

        if(null == saveEntity.getBudgetAmt()) {
            saveEntity.setBudgetAmt(BigDecimal.ZERO.setScale(8));
        }
        saveEntity = purchaseBillService.saveOrUpdatePurchaseBill(saveEntity);

        return CommonResponse.success("保存成功！", BeanMapper.map(saveEntity, PurchaseBillVO.class));
    }

    /**
     * 根据采购流程单据Id查询对应的采购申请报告详情
     *
     * @param id
     * @return
     */
    @GetMapping("queryDetail")
    public CommonResponse<PurchaseBillVO> queryDetail(@RequestParam(value = "id") Long id) {
        PurchaseBillVO vo = null;

        PurchaseBillEntity dbEntity = purchaseBillService.selectById(id);
        if(null != dbEntity) {
            vo = BeanMapper.map(dbEntity, PurchaseBillVO.class);
            return CommonResponse.success("查询采购申请报告详情成功！", vo);
        }

        UserContext userContext = sessionManager.getUserContext();
        QueryWrapper<PurchaseBillEntity> billQuery = new QueryWrapper<>();
        billQuery.eq("purchase_process_id", id);
        billQuery.eq("create_user_id", userContext.getUserId());

        dbEntity = purchaseBillService.getOne(billQuery);

        if(null != dbEntity) {
            vo = BeanMapper.map(dbEntity, PurchaseBillVO.class);

            QueryWrapper<SoftwareNeedsListEntity> softQuery = new QueryWrapper<>();
            softQuery.eq("purchase_bill_id", dbEntity.getId());
            softQuery.eq("purchase_process_id", id);

            List<SoftwareNeedsListEntity> softList = softwareNeedsListService.list(softQuery);
            if(CollectionUtils.isNotEmpty(softList)) {
                vo.setSoftwareNeedsList(BeanMapper.mapList(softList, SoftwareNeedsListVO.class));
            }
        } else {
            PurchaseBillEntity newEntity = new PurchaseBillEntity();
            newEntity.setPurchaseProcessId(id);
            newEntity.setCreateUserId(userContext.getUserId());
            newEntity.setCreateUserName(userContext.getUserName());
            purchaseBillService.saveOrUpdate(newEntity, false);
            vo = BeanMapper.map(newEntity, PurchaseBillVO.class);
        }
        return CommonResponse.success("查询采购申请报告详情成功！", vo);
    }
}
