package com.ejianc.poc.gyy.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.gyypoc.vo.PurchaseProcessVO;
import com.ejianc.business.gyypoc.vo.SoftwareNeedsListVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.poc.gyy.bean.PurchaseProcessEntity;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.mapper.PurchaseProcessMapper;
import com.ejianc.poc.gyy.service.IPurchaseProcessService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/23 15:51
 */
@Service(value = "purchaseProcessService")
public class PurchaseProcessServiceImpl extends BaseServiceImpl<PurchaseProcessMapper, PurchaseProcessEntity> implements IPurchaseProcessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISoftwareNeedsListService softwareNeedsListService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseProcessVO savePurChaseProcess(PurchaseProcessEntity dbEntity, List<SoftwareNeedsListEntity> saveList) {
        PurchaseProcessVO vo= null;
        if(CollectionUtils.isNotEmpty(saveList)) {
            softwareNeedsListService.saveOrUpdateBatch(saveList);
        }

        super.saveOrUpdate(dbEntity, false);
        vo = BeanMapper.map(dbEntity, PurchaseProcessVO.class);
        vo.setSoftwareNeedsList(BeanMapper.mapList(saveList, SoftwareNeedsListVO.class));
        return vo;
    }
}
