package com.ejianc.poc.gyy.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 流程主表单据实体
 *
 * @author CJ
 * @Description: 流程主表单据实体
 * @date 2021/3/23 15:36
 */
@TableName(value = "ejc_gyypoc_purchase_process")
public class PurchaseProcessEntity extends BaseEntity {

    private static final long serialVersionUID = 5015560652734671997L;

    /**
     * 主流程编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 主流程名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 主流程阶段状态：0-填报，1-汇总审批，2-采购，3-验收, 4-已结束
     */
    @TableField(value = "process_state")
    private Integer processState;

    /**
     * 申请预算
     */
    @TableField(value = "apply_budget_amt")
    private BigDecimal applyBudgetAmt;

    /**
     * 审批预算
     */
    @TableField(value = "review_budget_amt")
    private BigDecimal reviewBudgetAmt;

    /**
     * 验收数量
     */
    @TableField(value = "rec_num")
    private Double recNum;

    /**
     * 会议纪要
     */
    @TableField(value = "meeting_summary")
    private String meetingSummary;

    public String getMeetingSummary() {
        return meetingSummary;
    }

    public void setMeetingSummary(String meetingSummary) {
        this.meetingSummary = meetingSummary;
    }

    public BigDecimal getApplyBudgetAmt() {
        return applyBudgetAmt;
    }

    public void setApplyBudgetAmt(BigDecimal applyBudgetAmt) {
        this.applyBudgetAmt = applyBudgetAmt;
    }

    public BigDecimal getReviewBudgetAmt() {
        return reviewBudgetAmt;
    }

    public void setReviewBudgetAmt(BigDecimal reviewBudgetAmt) {
        this.reviewBudgetAmt = reviewBudgetAmt;
    }

    public Double getRecNum() {
        return recNum;
    }

    public void setRecNum(Double recNum) {
        this.recNum = recNum;
    }

    public Integer getProcessState() {
        return processState;
    }

    public void setProcessState(Integer processState) {
        this.processState = processState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
