package com.ejianc.poc.gyy.service.impl;

import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.poc.gyy.bean.PurchaseBillEntity;
import com.ejianc.poc.gyy.service.IPurchaseBillService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 采购申请报告审批回调
 *
 * @author CJ
 * @Description: 采购申请报告审批回调
 * @date 2021/3/23 17:04
 */
@Service(value = "purchaseBill")
public class PurchaseBillBpmCallbackServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurchaseBillService purchaseBillService;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("采购申请报告提交审批回调--billId:{}, state: {}", billId, state);

        //此处billId即为单据Id
        PurchaseBillEntity entity = purchaseBillService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();

        //设置提交人信息
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());

        purchaseBillService.saveOrUpdate(entity, false);
        return CommonResponse.success("采购申请报告提交审批回调成功！");
    }

    /**
     * 审批完成回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("采购申请报告批完成回调--billId:{}, state: {}", billId, state);

        //此处billId即为单据Id
        PurchaseBillEntity entity = purchaseBillService.selectById(billId);

        if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            //直审时记录
            UserContext userContext = sessionManager.getUserContext();
            //设置提交人信息
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
            purchaseBillService.saveOrUpdate(entity, false);
        }

        return CommonResponse.success("采购申请报告批完成回调成功！");
    }
}
