/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.gyy.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.gyypoc.vo.SoftReceiveCheckVO;
import com.ejianc.business.gyypoc.vo.SoftwareNeedsListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.gyy.bean.SoftReceiveCheckEntity;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.service.ISoftReceiveCheckService;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"softReceiveCheck"})
public class SoftReceiveCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISoftReceiveCheckService service;
    @Autowired
    private ISoftwareNeedsListService needsListService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SoftReceiveCheckVO> saveOrUpdate(@RequestBody SoftReceiveCheckVO saveorUpdateVO) {
        SoftReceiveCheckEntity entity = (SoftReceiveCheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SoftReceiveCheckEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SoftReceiveCheckVO vo = (SoftReceiveCheckVO)BeanMapper.map((Object)((Object)entity), SoftReceiveCheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SoftReceiveCheckVO> queryDetail(Long id) {
        SoftReceiveCheckEntity entity = (SoftReceiveCheckEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"need_id", (Object)id);
            entity = (SoftReceiveCheckEntity)((Object)this.service.getOne((Wrapper)wrapper));
        }
        if (entity == null) {
            SoftwareNeedsListEntity needsListEntity = (SoftwareNeedsListEntity)((Object)this.needsListService.selectById(id));
            entity = new SoftReceiveCheckEntity();
            entity.setId(IdWorker.getId());
            entity.setBillState(0);
            entity.setProcessId(needsListEntity.getPurchaseProcessId());
            entity.setNeedId(needsListEntity.getId());
            entity.setName(needsListEntity.getSoftwareName());
            entity.setDeveloperName(needsListEntity.getSupplierName());
            needsListEntity.setRecId(entity.getId());
            entity.setOrgId(needsListEntity.getApplyOrgId());
            this.needsListService.saveOrUpdate((Object)needsListEntity);
            this.service.saveOrUpdate((Object)entity);
        }
        SoftReceiveCheckVO vo = (SoftReceiveCheckVO)BeanMapper.map((Object)((Object)entity), SoftReceiveCheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SoftReceiveCheckVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SoftReceiveCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SoftReceiveCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMobileList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SoftwareNeedsListVO>> queryMobileList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("softwareName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("softwareVersion");
        fuzzyFields.add("mainFunction");
        CommonResponse response = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (response.isSuccess()) {
            param.getParams().put("applyOrgId", new Parameter("in", ((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.needsListService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SoftwareNeedsListVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

