package com.ejianc.business.house.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租赁收入上交
 * 
 * @author generator
 * 
 */
public class ZlsrsjVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long zlsrId; // 租赁收入id
    private String zlsrName; // 租赁收入名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qdrq; // 上交日期
    private Long jbrId; // 经办人id
    private String jbrName; // 经办人名称
    private Integer htzt; // 上交状态，0未上交，1已上交
    private String remark; // 备注
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Date beginDate; // 开始日期
    private Date endDate; // 结束日期
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改人

    private Long htbhId; // 合同编号id
    private String htbhName; // 合同编号名称
    private String bdcbh; // 不动产编号
    private String fwzl; // 房屋坐落
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "house-zlsr")
    public Long getZlsrId() {
        return zlsrId;
    }

    @ReferDeserialTransfer
    public void setZlsrId(Long zlsrId) {
        this.zlsrId = zlsrId;
    }
    public String getZlsrName() {
        return zlsrName;
    }

    public void setZlsrName(String zlsrName) {
        this.zlsrName = zlsrName;
    }
    public Date getQdrq() {
        return qdrq;
    }

    public void setQdrq(Date qdrq) {
        this.qdrq = qdrq;
    }
    @ReferSerialTransfer(referCode = "idm-user")

    public Long getJbrId() {
        return jbrId;
    }
    @ReferDeserialTransfer
    public void setJbrId(Long jbrId) {
        this.jbrId = jbrId;
    }
    public String getJbrName() {
        return jbrName;
    }

    public void setJbrName(String jbrName) {
        this.jbrName = jbrName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Integer getHtzt() {
        return htzt;
    }

    public void setHtzt(Integer htzt) {
        this.htzt = htzt;
    }


    public Long getHtbhId() {
        return htbhId;
    }

    public void setHtbhId(Long htbhId) {
        this.htbhId = htbhId;
    }
    public String getHtbhName() {
        return htbhName;
    }

    public void setHtbhName(String htbhName) {
        this.htbhName = htbhName;
    }
    public String getBdcbh() {
        return bdcbh;
    }

    public void setBdcbh(String bdcbh) {
        this.bdcbh = bdcbh;
    }
    public String getFwzl() {
        return fwzl;
    }

    public void setFwzl(String fwzl) {
        this.fwzl = fwzl;
    }
}
