package com.ejianc.business.hr.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.vo.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.hr.bean.BaseUserEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人力基础人员信息
 * 
 * @author generator
 * 
 */
@Mapper
public interface BaseUserMapper extends BaseCrudMapper<BaseUserEntity> {
    /**
     * 查询所有人员信息
     * @return
     */
    List<UserDataVO> queryAllUserData(Page<UserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 查询所有建造师信息
     * @return
     */
    List<RegisterTypeDataVO> queryRegisterReport(Page<RegisterTypeDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 查询所有派驻信息
     * @return
     */
    List<ResidencyUserDataVO> queryResidencyUserData(Page<ResidencyUserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 查询人事信息
     * @return
     */
    List<ResidencyUserDataVO> queryUserChangeData(Page<ResidencyUserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);










    /**
     * 根据组织获取性别分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> querySexType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取工龄分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryWorkYearType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取年龄分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryAgeType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取学历分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryEductionType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取职称分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryZcType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取证书类别分布
     * @param orgCodes
     * @param typeCodes 证书种类，不传查询全部
     * @return
     */
    List<TypeVO> queryRegisterType(@Param("orgCodes") List<String> orgCodes,@Param("typeCodes") List<String> typeCodes);
    /**
     * 根据组织获取建造师类别分布
     * @param orgCodes
     * @param registerType 建造师类别 09是一级建造师 14是二级建造师
     * @return
     */
    List<TypeVO> queryRegisterTypeDetail(@Param("orgCodes") List<String> orgCodes,@Param("registerType") String registerType);
    /**
     * 根据组织获取核心人才梯队
     * @param orgCodes
     * @param typeCodes 人员梯队种类，不传查询全部
     * @return
     */
    List<TypeVO> queryUserLevel(@Param("orgCodes") List<String> orgCodes,@Param("typeCodes") List<String> typeCodes);

    /**
     * 根据组织获取人事异动
     * @param orgCodes
     * @param typeCode 人事异动类型，不传查询全部
     * @param year
     * @param month
     * @return
     */
    List<TypeVO> queryUserChange(@Param("orgCodes") List<String> orgCodes,
                                 @Param("typeCode") String typeCode,
                                 @Param("year") Integer year,
                                 @Param("month") Integer month);




    /**
     * 根据组织获取近12个月工资总额波动
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryMnyChange(@Param("orgCodes") List<String> orgCodes);


    /**
     * 查询人员欠薪明细
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyDetail(Page<UserMnyDetailVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 查询个人欠薪统计
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyData(Page<UserMnyDetailVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

}
