package com.ejianc.business.hr.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.bean.BaseUserEntity;
import com.ejianc.business.hr.vo.*;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
public interface IBaseUserService extends IBaseService<BaseUserEntity> {
    /**
     * 查询所有人员信息
     *
     * @return
     */
    List<UserDataVO> queryAllUserData(Page<UserDataVO> page, QueryWrapper wrapper);
    /**
     * 查询所有建造师信息
     *
     * @return
     */
    List<RegisterTypeDataVO> queryRegisterReport(Page<RegisterTypeDataVO> page,QueryWrapper wrapper);
    /**
     * 查询所有派驻信息
     *
     * @return
     */
    List<ResidencyUserDataVO> queryResidencyUserData(Page<ResidencyUserDataVO> page, QueryWrapper wrapper);
    /**
     * 查询人事信息
     * @return
     */
    List<ResidencyUserDataVO> queryUserChangeData(Page<ResidencyUserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);





















    /**
     * 根据组织过滤查询年龄分布
     *
     * @param orgCodes
     * @return
     */
    List<TypeVO> querySexType(List<String> orgCodes);

    /**
     * 根据组织过滤查询工龄分布
     *
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryWorkYearType(List<String> orgCodes);

    /**
     * 根据组织获取年龄分布
     *
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryAgeType(List<String> orgCodes);

    /**
     * 根据组织获取学历分布
     *
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryEductionType(List<String> orgCodes);

    /**
     * 根据组织获取职称分布
     *
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryZcType(List<String> orgCodes);

    /**
     * 根据组织获取证书类别分布
     *
     * @param orgCodes
     * @param typeCodes 证书种类，不传查询全部
     * @return
     */
    List<TypeVO> queryRegisterType(List<String> orgCodes, List<String> typeCodes);

    /**
     * 根据组织获取建造师类别分布
     *
     * @param orgCodes
     * @param registerType 建造师类别 09是一级建造师 14是二级建造师
     * @return
     */
    List<TypeVO> queryRegisterTypeDetail(List<String> orgCodes, String registerType);

    /**
     * 根据组织获取核心人才梯队
     *
     * @param orgCodes
     * @param typeCodes 人员梯队种类，不传查询全部
     * @return
     */
    List<TypeVO> queryUserLevel(List<String> orgCodes, List<String> typeCodes);

    /**
     * 根据组织获取人事异动
     *
     * @param orgCodes
     * @param typeCode 人事异动类型，不传查询全部
     * @param year
     * @param month
     * @return
     */
    List<TypeVO> queryUserChange(List<String> orgCodes, String typeCode, Integer year, Integer month);

    /**
     * 根据组织获取近12个月工资总额波动
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryMnyChange(List<String> orgCodes);



    /**
     * 查询人员欠薪明细
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyDetail(Page<UserMnyDetailVO> page,QueryWrapper wrapper);
    /**
     * 查询个人欠薪统计
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyData(Page<UserMnyDetailVO> page,QueryWrapper wrapper);

}
