/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.hr.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.RegisterTypeDataVO;
import com.ejianc.business.hr.vo.ResidencyUserDataVO;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"baseUser"})
public class BaseUserController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBaseUserService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryAllUserData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserDataVO>> queryAllUserData(@RequestBody QueryParam param) {
        String flag;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        if (param.getParams().containsKey("workYear")) {
            flag = ((Parameter)param.getParams().get("workYear")).getValue().toString();
            param.getParams().remove("workYear");
            if ("1".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year = 1"));
            } else if ("2".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 1 and work_year <=3"));
            } else if ("3".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 3 and work_year <=5"));
            } else if ("4".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 5 and work_year <=10"));
            } else if ("5".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 10 and work_year <=15"));
            } else if ("6".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 15"));
            }
        }
        if (param.getParams().containsKey("age")) {
            flag = ((Parameter)param.getParams().get("age")).getValue().toString();
            param.getParams().remove("age");
            if ("1".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age <= 25"));
            } else if ("2".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 25 and age <=35"));
            } else if ("3".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 35 and age <=45"));
            } else if ("4".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 45 and age <=55"));
            } else if ("5".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 55"));
            }
        }
        if (param.getParams().containsKey("title") && "0".equals(flag = ((Parameter)param.getParams().get("title")).getValue().toString())) {
            param.getParams().remove("title");
            param.getParams().put("title", new Parameter("sql", (Object)"title is null or title = ''"));
        }
        if (param.getParams().containsKey("educationName") && "\u65e0".equals(flag = ((Parameter)param.getParams().get("educationName")).getValue().toString())) {
            param.getParams().remove("educationName");
            param.getParams().put("educationName", new Parameter("sql", (Object)"education_name is null or education_name = '' or education_id = 99 "));
        }
        if (param.getParams().containsKey("departmentName") && "\u5f85\u5c97\u4eba\u5458".equals(flag = ((Parameter)param.getParams().get("departmentName")).getValue().toString()) && "ne".equals(((Parameter)param.getParams().get("departmentName")).getType())) {
            param.getParams().remove("departmentName");
            param.getParams().put("departmentName", new Parameter("sql", (Object)"department_name is null or department_name != \u5f85\u5c97\u4eba\u5458 "));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<UserDataVO> userDataVOS = this.service.queryAllUserData((Page<UserDataVO>)page, wrapper);
        for (UserDataVO reportVO : userDataVOS) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(userDataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryRegisterReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RegisterTypeDataVO>> queryRegisterReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryRegisterReport((Page<RegisterTypeDataVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryResidencyUserData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryResidencyUserData(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        Object orgVOList = null;
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryResidencyUserData((Page<ResidencyUserDataVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryUserChangeData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryUserChangeData(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("h.A0101");
        fuzzyFields.add("a.A0100");
        fuzzyFields.add("a.dw");
        fuzzyFields.add("a.gw");
        fuzzyFields.add("c.codeitemdesc");
        param.getParams().put("postName", new Parameter("like", (Object)"\u4eba\u4e8b"));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryUserChangeData((Page<ResidencyUserDataVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryOrgType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryOrgType(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("h.A0101");
        fuzzyFields.add("a.A0100");
        fuzzyFields.add("a.dw");
        fuzzyFields.add("a.gw");
        fuzzyFields.add("c.codeitemdesc");
        param.getParams().put("postName", new Parameter("like", (Object)"\u4eba\u4e8b"));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryOrgType((Page<TypeVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

