/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.hr.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.service.IResidencyUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.ResidencyUserVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"residencyUser"})
public class ResidencyUserController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IResidencyUserService residencyUserService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUserApi userApi;

    @RequestMapping(value={"/queryResidencyUser"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyUser(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        if (param.getParams().get("orgName") != null && "null".equals(((Parameter)param.getParams().get("orgName")).getValue().toString())) {
            param.getParams().put("orgName", new Parameter("eq", null));
        }
        if (param.getParams().get("departmentName") != null && "null".equals(((Parameter)param.getParams().get("departmentName")).getValue().toString())) {
            param.getParams().put("departmentName", new Parameter("eq", null));
        }
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            param.getParams().put("orgCode", new Parameter("in", orgCodes));
            param.getParams().remove("orgId");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ResidencyUserVO> userDataVOS = this.residencyUserService.queryResidencyUser((Page<ResidencyUserVO>)page, wrapper);
        for (UserDataVO userDataVO : userDataVOS) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(userDataVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                userDataVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(userDataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryResidencyRange"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyRange(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        param.getParams().put("e_type_name", new Parameter("eq", (Object)"\u5728\u5c97"));
        param.getParams().put("post_code", new Parameter("in", Arrays.asList(1, 2)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ResidencyUserVO> userDataVOS = this.residencyUserService.queryResidencyRange((Page<ResidencyUserVO>)page, wrapper);
        for (UserDataVO userDataVO : userDataVOS) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(userDataVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                userDataVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(userDataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryResidencyProjectRange"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyProjectRange(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        fuzzyFields.add("department_name");
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            param.getParams().put("orgCode", new Parameter("in", orgCodes));
            param.getParams().remove("orgId");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        param.getParams().put("e_type_name", new Parameter("eq", (Object)"\u5728\u5c97"));
        param.getParams().put("post_code", new Parameter("in", Arrays.asList(1, 2)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ResidencyUserVO> userDataVOS = this.residencyUserService.queryResidencyProjectRange((Page<ResidencyUserVO>)page, wrapper);
        for (UserDataVO userDataVO : userDataVOS) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(userDataVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                userDataVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(userDataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

