/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.hr.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.OrgPayReportVO;
import com.ejianc.business.hr.vo.SalaryDetailVO;
import com.ejianc.business.hr.vo.UnderReportVO;
import com.ejianc.business.hr.vo.UserMnyDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"userMny"})
public class UserMnyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBaseUserService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUserApi userApi;

    @RequestMapping(value={"/queryUserMnyDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserMnyDetailVO>> queryUserMnyDetail(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryUserMnyDetail((Page<UserMnyDetailVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryUserMnyData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserMnyDetailVO>> queryUserMnyData(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<UserMnyDetailVO> vos = this.service.queryUserMnyData((Page<UserMnyDetailVO>)page, wrapper);
        for (UserMnyDetailVO reportVO : vos) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryUnderReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UnderReportVO>> queryUnderReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgCode", "asc");
        param.getOrderMap().put("year", "asc");
        param.getOrderMap().put("month", "asc");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryUnderReport((Page<UnderReportVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryOrgUnder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UnderReportVO>> queryOrgUnder(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgCode", "asc");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryOrgUnder((Page<UnderReportVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryOrgUnderNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UnderReportVO>> queryOrgUnderNum(@RequestBody QueryParam param) {
        String flag;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgCode", "asc");
        if (param.getParams().containsKey("num") && "4".equals(flag = ((Parameter)param.getParams().get("num")).getValue().toString())) {
            param.getParams().remove("num");
            param.getParams().put("num", new Parameter("sql", (Object)"num > 3"));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryOrgUnderNum((Page<UnderReportVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryOrgPayReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrgPayReportVO>> queryOrgPayReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgCode", "asc");
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            param.getParams().put("orgCode", new Parameter("in", orgCodes));
            param.getParams().remove("orgId");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryOrgPayReport((Page<OrgPayReportVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5355\u4f4d\u85aa\u916c\u660e\u7ec6\uff01", (Object)page);
    }

    @RequestMapping(value={"/querySalaryDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryDetailVO>> querySalaryDetail(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("name");
        fuzzyFields.add("ac_set");
        fuzzyFields.add("salary_org_name");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (param.getParams().containsKey("departmentCode") && ((Parameter)param.getParams().get("departmentCode")).getValue() != null) {
            param.getParams().remove("orgId");
        } else if (CollectionUtils.isNotEmpty(orgCodes)) {
            param.getParams().put("orgCode", new Parameter("in", orgCodes));
            param.getParams().remove("orgId");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<SalaryDetailVO> salaryDetailVOS = this.service.querySalaryDetail((Page<SalaryDetailVO>)page, wrapper);
        for (SalaryDetailVO vo : salaryDetailVOS) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(vo.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                vo.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(salaryDetailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5458\u85aa\u916c\u660e\u7ec6\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

