/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.vo.HrAllUserESVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/es/"})
public class EsController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String HR_INDEX_NAME = "hr_useryl";
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Autowired
    private IUserApi userApi;

    @RequestMapping(value={"getHrAllUserESVO"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<HrAllUserESVO>> employeePage(@RequestBody QueryParam param) {
        Page page = new Page();
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        SearchRequest searchRequest = new SearchRequest(new String[]{HR_INDEX_NAME});
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            MatchQueryBuilder emName = QueryBuilders.matchQuery((String)"dw", (Object)param.getSearchText());
            boolQuery.must((QueryBuilder)emName.operator(Operator.AND));
        }
        for (Map.Entry entry : params.entrySet()) {
            String string = (String)entry.getKey();
            String value = this.getParamValue(params, string);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)string, (Object)value));
        }
        searchRequest.source().from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        searchRequest.source().size(pageSize);
        searchRequest.source().query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    searchRequest.source().sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                searchRequest.source().sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        searchRequest.source().query((QueryBuilder)boolQuery);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                this.logger.info("----------------ES\u83b7\u53d6\u6570\u636e\u4e3a--------------\uff1a{}", (Object)sourceAsString);
                arrayList.add(JSON.parseObject((String)sourceAsString, HrAllUserESVO.class));
                page.setCurrent((long)pageNumber);
                page.setSize((long)pageSize);
                page.setRecords(arrayList);
                page.setTotal(hits.getTotalHits().value);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException.getMessage());
            throw new BusinessException("\u6839\u636e paramMap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + iOException.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

