package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.service.IResidencyUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 派驻人员管理
 *
 * @author Jiang
 *
 */
@Controller
@RequestMapping("residencyUser")
public class ResidencyUserController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IResidencyUserService residencyUserService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUserApi userApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;


    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryResidencyUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyUser(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");

//        service.queryHrOrgData("1");
        if(param.getParams().get("orgName") != null && "null".equals(param.getParams().get("orgName").getValue().toString())){
            param.getParams().put("orgName",new Parameter(QueryParam.EQ, null));
        }
        if(param.getParams().get("departmentName") != null && "null".equals(param.getParams().get("departmentName").getValue().toString())){
            param.getParams().put("departmentName",new Parameter(QueryParam.EQ, null));
        }
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        /**
         *实现分页
         */
        Page<ResidencyUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
//        param.getParams().put("residencyType",new Parameter(QueryParam.NE,null));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<ResidencyUserVO> userDataVOS = residencyUserService.queryResidencyUser(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryResidencyRange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyRange(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");

//        service.queryHrOrgData("1");
//        /**
//         * 组织隔离
//         */
//        //普通组织 id
//        List<OrgVO> orgVOList = new ArrayList<>();
//        List<String> orgCodes = new ArrayList<>();
//        if(!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getCode());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }

        /**
         *实现分页
         */
        Page<ResidencyUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        param.getParams().put("e_type_name",new Parameter(QueryParam.EQ,"在岗"));
        param.getParams().put("post_code",new Parameter(QueryParam.IN, Arrays.asList(1,2)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<ResidencyUserVO> userDataVOS = residencyUserService.queryResidencyRange(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryResidencyProjectRange 查询派驻人员项目分布
     */
    @RequestMapping(value = "/queryResidencyProjectRange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyProjectRange(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        fuzzyFields.add("department_name");

//        service.queryHrOrgData("1");
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        List<Long> orgIds = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().remove("orgId");

        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
            orgIds.add(org.getId());
        });

        List<Long> projectDepartmentIds = new ArrayList<>();
        if(param.getParams().containsKey("businessStatus")){


            QueryParam projectPoolParam = new QueryParam();
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                projectPoolParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
            }
            projectPoolParam.getParams().put("businessStatus",param.getParams().get("businessStatus"));
            param.getParams().remove("businessStatus");
            CommonResponse<JSONArray> commonResponse = projectPoolApi.getProjectPoolList(projectPoolParam);
            if(!commonResponse.isSuccess()){
                throw new BusinessException("查询在建项目失败!");
            } else {
                List<ProjectPoolSetVO> projectPoolSetVOS = commonResponse.getData().toJavaList(ProjectPoolSetVO.class);
                if(ListUtil.isNotEmpty(projectPoolSetVOS)){
                    projectDepartmentIds = projectPoolSetVOS.stream().map(ProjectPoolSetVO::getProjectDepartmentId).collect(Collectors.toList());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(projectDepartmentIds)) {
            ArrayList<String> projectCods = new ArrayList<>();
            for (OrgVO vo : orgVOList) {
                for (Long departmentId : projectDepartmentIds) {
                    if(vo.getId().equals(departmentId)){
                        projectCods.add(vo.getCode());
                    }
                }
            }
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("department_code", new Parameter(QueryParam.IN, projectCods));

        } else if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("org_code", new Parameter(QueryParam.IN, orgCodes));
        }
        /**
         *实现分页
         */
        Page<ResidencyUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        param.getParams().put("e_type_name",new Parameter(QueryParam.EQ,"在岗"));
        param.getParams().put("post_code",new Parameter(QueryParam.IN, Arrays.asList(1,2)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<ResidencyUserVO> userDataVOS = residencyUserService.queryResidencyProjectRange(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 门户-查询派驻人员类别
     */
    @RequestMapping(value = "/queryResidencyType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryResidencyType(@RequestBody QueryParam param) {

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            String orgType =param.getParams().get("orgType").getValue().toString();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }

        /**
         *实现分页
         */
        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<TypeVO> vos = residencyUserService.queryResidencyType(page, wrapper);
        page.setRecords(vos);
        return CommonResponse.success("查询派驻人员类别数据成功！", page);
    }

}
