package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.hr.mapper.BaseUserMapper;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.utils.DateUtil;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UnderReportVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 人员结构
 *
 * @author generator
 */
@Controller
@RequestMapping("userStruct")
public class UserStructController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBaseUserService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private BaseUserMapper baseUserMapper;
    @Autowired
    private IZjllApi zjllApi;
    @Autowired
    private IEmployeeApi employeeApi;

    /**
     * @param param
     * @Description querySexType
     * 年龄分布饼状图;
     */
    @RequestMapping(value = "/querySexType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> querySexType(@RequestBody QueryParam param) {

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.querySexType(wrapper);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }


    /**
     * @param param
     * @Description queryWorkYearType
     * 工龄分布饼状图;
     */
    @RequestMapping(value = "/queryWorkYearType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryWorkYearType(@RequestBody QueryParam param) {

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.queryWorkYearType(wrapper);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryAgeType
     * 年龄分布饼状图;
     */
    @RequestMapping(value = "/queryAgeType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryAgeType(@RequestBody QueryParam param) {

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.queryAgeType(wrapper);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryEductionType
     * 学历分布饼状图;
     */
    @RequestMapping(value = "/queryEductionType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryEductionType(@RequestBody QueryParam param) {

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.queryEductionType(wrapper);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryZcType
     * 职称分布饼状图;
     */
    @RequestMapping(value = "/queryZcType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryZcType(@RequestBody QueryParam param) {

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.queryZcType(wrapper);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryRegisterTypeDetail
     * 根据组织获取证书类别分布
     */
    @RequestMapping(value = "/queryRegisterType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryRegisterType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.queryRegisterType(null, null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryRegisterTypeDetail
     * 根据组织获取建造师类别分布
     */
    @RequestMapping(value = "/queryRegisterTypeDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryRegisterTypeDetail(@RequestBody QueryParam param) {

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        if(param.getParams().get("zt") != null){



            QueryParam zzllParam = new QueryParam();
            zzllParam.setPageSize(-1);
            zzllParam.setPageIndex(1);
            //0有效，1无效
            zzllParam.getParams().put("yxzt",new Parameter(QueryParam.EQ,"0"));
            zzllParam.getParams().put("zt",param.getParams().get("zt"));
            zzllParam.getParams().put("dr",new Parameter(QueryParam.EQ,"0"));
            param.getParams().remove("zt");

            CommonResponse<JSONArray> commonResponse = zjllApi.queryUserIdList(zzllParam);
            if(!commonResponse.isSuccess()){
                throw new BusinessException("查询在建履历失败!");
            }
            List<Long> userIds = commonResponse.getData().toJavaList(Long.class);
            logger.info("查询人员id为:{}", JSON.toJSONString(userIds));
            CommonResponse<List<EmployeeVO>> commonResponse1 = employeeApi.getJustByIds(userIds);
            if(!commonResponse1.isSuccess()){
                throw new BusinessException("查询employee信息失败!");
            }
            List<EmployeeVO> employeeVOS = commonResponse1.getData();
            logger.info("查询人员employeeVO为:{}", JSON.toJSONString(employeeVOS));
            List<String> employeeCodes = employeeVOS.stream().map(EmployeeVO::getCode).collect(Collectors.toList());
            logger.info("查询人员employeeCode为:{}", JSON.toJSONString(employeeCodes));

            //只看一建占用
            param.getParams().put("registerLevel",new Parameter(QueryParam.EQ,"10101"));
            param.getParams().put("employeeCode ",new Parameter(QueryParam.IN,employeeCodes));

        }


        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TypeVO> typeVOS = service.queryRegisterTypeDetail(wrapper);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryUserLevel
     * 根据组织获取核心人才梯队
     */
    @RequestMapping(value = "/queryUserLevel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryUserLevel(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        List<TypeVO> typeVOS = service.queryUserLevel(null, null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryRegisterTypeDetail
     * 根据组织获取建造师类别分布
     */
    @RequestMapping(value = "/queryUserChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryUserChange(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        String typeCode = null;
        List<String> typeCodes = new ArrayList<>();
        Integer year = null;
        Integer month = null;
        if (param.getParams().get("typeCode") != null) {
            typeCode = param.getParams().get("typeCode").getValue().toString();
            String[] split = typeCode.split(",");
            typeCodes = Arrays.asList(split);
        }
        if (param.getParams().get("year") != null) {
            year = Integer.valueOf(param.getParams().get("year").getValue().toString());
        }
        if (param.getParams().get("month") != null) {
            month = Integer.valueOf(param.getParams().get("month").getValue().toString());
        }
        List<TypeVO> typeVOS = new ArrayList<>();
        if (typeCode.equals("6")) {
            typeVOS = service.queryUserChangeLz(null, typeCodes, year, month);
        } else if (typeCode.equals("9")) {
            typeVOS = service.queryUserChangeRetire(null, typeCodes, year, month);
        } else {
            typeVOS = service.queryUserChange(null, typeCodes, year, month);
        }
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryMnyChange
     * 根据组织获取近12个月工资总额波动
     */
    @RequestMapping(value = "/queryMnyChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryMnyChange(@RequestBody QueryParam param) {


        List<TypeVO> typeVOS = service.queryMnyChange(null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryMnyChange
     * 根据组织获取近12个月工资总额波动
     */
    @RequestMapping(value = "/queryUnderMnyChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UnderReportVO>> queryUnderMnyChange(@RequestBody QueryParam param) {
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));

            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<UnderReportVO> underReportVOS = baseUserMapper.queryUnderChange(wrapper);
        return CommonResponse.success("查询列表数据成功！", underReportVOS);
    }

    /**
     * @param param
     * @Description queryTrainTop
     * 培训管理每场培训参加人数
     */
    @RequestMapping(value = "/queryTrainTop", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryTrainTop(@RequestBody QueryParam param) {

        String startDate = "";
        String endDate = "";
        if(param.getParams().containsKey("startDate")){
            startDate = param.getParams().get("startDate").getValue().toString();
        }
        if(param.getParams().containsKey("endDate")){
            endDate = param.getParams().get("endDate").getValue().toString();
        }

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);



        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<TypeVO> vos  = baseUserMapper.queryTrainTop(page,wrapper);
        page.setRecords(vos);
//        List<TypeVO> vos = baseUserMapper.queryTrainTop(startDate,endDate);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryTrainType
     * 培训管理分类
     */
    @RequestMapping(value = "/queryTrainType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryTrainType(@RequestBody QueryParam param) {

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);



        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<TypeVO> vos  = baseUserMapper.queryTrainType(page,wrapper);
        page.setRecords(vos);
        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
