package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.api.IShareCategoryApi;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.*;
import com.ejianc.business.hr.vo.salarySystem.SalaryAttendanceDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryJobDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryTransferDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryUserDataVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.hr.service.IBaseUserService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Controller
@RequestMapping("baseUser")
public class BaseUserController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IEmployeeApi employeeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBaseUserService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCategoryApi shareCategoryApi;

    public static List<Long> ignoreOrgIds = Arrays.asList(
            1502571153791651841L,
            1502571153867149313L,
            1502571153946841090L,
            1502571154018144258L,
            1502571154072670209L,
            1502571154123001857L,
            1502571154173333505L,
            1502571154223665153L,
            1502571154273996802L,
            1502571154383048706L,
            1502571154433380353L,
            1502571154655678465L,
            1502571154714398722L,
            1502571154785701889L,
            1502571154831839233L,
            1502571154890559490L,
            1502571155016388610L,
            1502571155255463937L,
            1502571156329205762L,
            1502571158292140033L,
            1502571158329888770L,
            1502571158547992578L,
            1502571158589935618L,
            1502571158661238786L,
            1633860192344920066L,
            1687493596574613506L,
            1777728175354720258L
    );

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryAllUserData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserDataVO>> queryAllUserData(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("sourceTypeSequence", "asc");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
//        service.queryHrOrgData("1");
//        /**
//         * 组织隔离
//         */
//        //普通组织 id
//        List<OrgVO> orgVOList = new ArrayList<>();
//        List<String> orgCodes = new ArrayList<>();
//        if (!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getCode());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            if(param.getParams().containsKey("orgType")){
                String orgType = param.getParams().get("orgType").getValue().toString();
                if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        if(param.getParams().containsKey("ignore")){
            param.getParams().remove("ignore");
            List<OrgVO> ignoreOrgVOList =  (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(ignoreOrgIds), true,"查询过滤掉组织失败，获取当前本下组织信息失败。");
            List<String> ignoreOrgCodes = new ArrayList<>();
            ignoreOrgVOList.stream().forEach(org -> {
                //普通组织
                ignoreOrgCodes.add(org.getCode());
            });
            orgVOList = orgVOList.stream().filter(s-> !ignoreOrgCodes.contains(s.getCode())).collect(Collectors.toList());
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }

        if (param.getParams().containsKey("workYear")) {
            String flag = param.getParams().get("workYear").getValue().toString();
            param.getParams().remove("workYear");
            if ("0".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year = 0"));
            } else if ("1".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year <= 1"));
            } else if ("2".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 1 + " and work_year <=" + 3));
            } else if ("3".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 3 + " and work_year <=" + 5));
            } else if ("4".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 5 + " and work_year <=" + 10));
            } else if ("5".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 10 + " and work_year <=" + 15));
            } else if ("6".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 15));
            }
        }
        if (param.getParams().containsKey("age")) {
            String flag = param.getParams().get("age").getValue().toString();

            param.getParams().remove("age");
            if ("1".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age <= 25"));
            } else if ("2".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 25 + " and age <=" + 35));
            } else if ("3".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 35 + " and age <=" + 45));
            } else if ("4".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 45 + " and age <=" + 55));
            } else if ("5".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 55));
            }
        }
        if (param.getParams().containsKey("title")) {
            String flag = param.getParams().get("title").getValue().toString();

            if ("0".equals(flag)) {
                param.getParams().remove("title");
                param.getParams().put("title", new Parameter(QueryParam.SQL, "title is null or title = ''"));
            }
        }
        if (param.getParams().containsKey("educationName")) {
            String flag = param.getParams().get("educationName").getValue().toString();

            if ("无".equals(flag)) {
                param.getParams().remove("educationName");
                param.getParams().put("educationName", new Parameter(QueryParam.SQL, "education_name is null or education_name = '' or education_id = 99 "));
            }
        }

        if (param.getParams().containsKey("departmentName")) {
            String flag = param.getParams().get("departmentName").getValue().toString();

            if (("待岗人员".equals(flag) && "ne".equals(param.getParams().get("departmentName").getType())) || "非待岗人员".equals(flag)) {
                param.getParams().remove("departmentName");
                param.getParams().put("departmentName", new Parameter(QueryParam.SQL, "(department_name is null or department_name != '待岗人员') "));
            }
        }
        /**
         * 岗级
         */
        if (param.getParams().containsKey("jobLevelCode")) {
            if (param.getParams().get("jobLevelCode").getValue().toString().equals("0")) {
                param.getParams().remove("jobLevelCode");
                param.getParams().put("jobLevelCode",new Parameter(QueryParam.SQL, "job_level_code is null")
                );
            }
        }
        if (param.getParams().containsKey("postCodeNew")) {
            if (param.getParams().get("postCodeNew").getValue().toString().equals("postCodeOther")) {
                param.getParams().remove("postCodeNew");
                param.getParams().put("postCodeNew",new Parameter(QueryParam.SQL, "(post_code_new is null or post_code_new = '')")
                );
            }
        }
        /**
         *实现分页
         */
        Page<UserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<UserDataVO> userDataVOS = service.queryAllUserData(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryRegisterReport 查询所有建造师信息
     */
    @RequestMapping(value = "/queryRegisterReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RegisterTypeDataVO>> queryRegisterReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("sourceTypeSequence", "asc");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        /**
         *实现分页
         */
        Page<RegisterTypeDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<RegisterTypeDataVO> vos = service.queryRegisterReport(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (RegisterTypeDataVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(vos);


        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryResidencyUserData 查询所有派驻信息
     */
    @RequestMapping(value = "/queryResidencyUserData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryResidencyUserData(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        if (param.getParams().get("orgName") != null && "null".equals(param.getParams().get("orgName").getValue().toString())) {
            param.getParams().put("orgName", new Parameter(QueryParam.EQ, null));
        }
        if (param.getParams().get("departmentName") != null && "null".equals(param.getParams().get("departmentName").getValue().toString())) {
            param.getParams().put("departmentName", new Parameter(QueryParam.EQ, null));
        }
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = null;
//        List<String> orgCodes = new ArrayList<>();
//        if (!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getName());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgName", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }
        /**
         *实现分页
         */
        Page<ResidencyUserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<ResidencyUserDataVO> vos = service.queryResidencyUserData(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (ResidencyUserDataVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }
        page.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryUserChangeData 查询人事信息
     */
    @RequestMapping(value = "/queryUserChangeData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryUserChangeData(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("h.A0101");
        fuzzyFields.add("a.A0100");
        fuzzyFields.add("a.dw");
        fuzzyFields.add("a.gw");
        fuzzyFields.add("c.codeitemdesc");
        /**
         * 组织隔离
         */
        //普通组织 id
//        List<OrgVO> orgVOList = null;
//        List<String> orgCodes = new ArrayList<>();
//        if (!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getName());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgName", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }

        param.getParams().put("postName", new Parameter(QueryParam.LIKE, "人事"));
        /**
         *实现分页
         */
        Page<ResidencyUserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<ResidencyUserDataVO> vos = service.queryUserChangeData(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (ResidencyUserDataVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        page.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryUserChangeData 查询人事信息
     */
    @RequestMapping(value = "/queryOrgType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryOrgType(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getOrderMap().put("typeCode", "asc");
        /**
         *实现分页
         */
        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryOrgType(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * @param param
     * @Description queryUserType
     */
    @RequestMapping(value = "/queryUserType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryUserType(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /**
         *实现分页
         */
        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryUserType(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryJobLevelReport 集团岗级职级分布
     */
    @RequestMapping(value = "/queryJobLevelReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JobLevelVO>> queryJobLevelReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("post_name");

        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");

        } else {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("a.b0110", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        param.getParams().put("a.a0198", new Parameter(QueryParam.NOT_IN, Arrays.asList("E","G","H","J","K")));

        /**
         *实现分页
         */
        Page<JobLevelVO> page = new Page<>(param.getPageIndex(), param.getPageSize() == 10 ? 50 : param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<JobLevelVO> jobLevelVOS = service.queryJobLevelReport(page, wrapper);
        jobLevelVOS = jobLevelVOS.stream().sorted(Comparator.comparing(JobLevelVO::getJobLevelCode).reversed()).collect(Collectors.toList());
        page.setRecords(jobLevelVOS);
        page.setTotal(jobLevelVOS.size());

        return CommonResponse.success("查询岗级职级！", page);

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description  项目任职人员查询
     */
    @RequestMapping(value = "/queryEmployeeReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryEmployeeReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("departmentName");

        /**
         * 组织隔离
         */
        boolean flag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                flag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                flag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(flag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryParam deepCopyParam = Utils.deepCopy(param);
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("sourceType", "desc");
        param.getOrderMap().put("employeeSequence", "asc");
        /**
         *实现分页
         */
        Page<ProjectEmployeeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<ProjectEmployeeVO> projectEmployeeVOS = service.queryEmployeeReport(page, wrapper);

        logger.info("任职表开始遍历，时间：{}", System.currentTimeMillis());
        for (ProjectEmployeeVO reportVO : projectEmployeeVOS) {
            try {
                String userCode = reportVO.getUserCode();
                //登录账号+,999912310000
                userCode = userCode + ",999912310000";
                //BASE64 GBK编码在URL GBK编码
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            } catch (Exception e) {
                e.printStackTrace();
            }
            CommonResponse<Boolean> booleanCommonResponse = null;
            if( "主职".equals(reportVO.getSourceType())) {
                 booleanCommonResponse = shareCategoryApi.queryUserSyncState(1,reportVO.getCard(), reportVO.getOrgCode(), reportVO.getDepartmentCode(), reportVO.getPostId(), null);
            }else {
                booleanCommonResponse = shareCategoryApi.queryUserSyncState(0,reportVO.getCard(), reportVO.getOrgCode(), reportVO.getDepartmentCode(), reportVO.getPostId(), null);

            }
            if (booleanCommonResponse.isSuccess() && booleanCommonResponse.getData()){
                reportVO.setIsSync("是");
            }else {
                reportVO.setIsSync("否");
            }

        }
        logger.info("任职表遍历结束，时间：{}", System.currentTimeMillis());

        //jobLevelVOS = jobLevelVOS.stream().sorted(Comparator.comparing(JobLevelVO::getJobLevelCode).reversed()).collect(Collectors.toList());
        page.setRecords(projectEmployeeVOS);
        //page.setTotal(projectEmployeeVOS.size());

        QueryWrapper wrapper2 = BaseServiceImpl.changeToQueryWrapper(deepCopyParam);

        wrapper2.groupBy("employee_code");
        Page<ProjectEmployeeVO> page1 = new Page<>(1, 1);
        List<ProjectEmployeeVO> projectEmployeeVOS2 = service.queryEmployeeReportNum(page1,wrapper2,"employee_code");
        Long zrs = 0L;//总人数
        zrs = page1.getTotal();

        QueryWrapper objectQueryWrapper = BaseServiceImpl.changeToQueryWrapper(deepCopyParam);
        objectQueryWrapper.groupBy("source_type");
        Page<ProjectEmployeeVO> page2 = new Page<>(-1, 1000);
        List<ProjectEmployeeVO> projectEmployeeVOS1 = service.queryEmployeeReportNum(page2,objectQueryWrapper,"source_type");
        Integer jz = 0;//兼职
        Integer zz = 0;//主职
        if (CollectionUtils.isNotEmpty(projectEmployeeVOS1)){
            for (ProjectEmployeeVO projectEmployeeVO : projectEmployeeVOS1) {
                if ("兼职".equals(projectEmployeeVO.getSourceType())){
                    jz = projectEmployeeVO.getNum();
                }else {
                    zz = projectEmployeeVO.getNum();
                }
            }
        }


        com.alibaba.fastjson.JSONObject pageData = new com.alibaba.fastjson.JSONObject();
        pageData.put("records", page.getRecords());
        pageData.put("total", page.getTotal());
        pageData.put("current", page.getCurrent());
        pageData.put("size", page.getSize());
        pageData.put("pages", page.getPages());
        pageData.put("jz", jz);
        pageData.put("zz", zz);
        pageData.put("zrs", zrs);
        return CommonResponse.success("查询岗级职级！", pageData);

    }

    /**
     * @param param
     * @Description queryAttendanceMonth 人员考勤月度明细
     */
    @RequestMapping(value = "/queryAttendanceMonth", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AttendanceMonthVO>> queryAttendanceMonth(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgSequence","ASC");
        param.getOrderMap().put("departmentSequence","ASC");
        param.getOrderMap().put("sequence","ASC");
        Long orgId = null;
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
             orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        if (orgId.equals(1502571152583692289L)){//选择的是集团
            param.getParams().remove("orgCode");
        }
        /**
         *实现分页
         */
        Page<AttendanceMonthVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<AttendanceMonthVO> vos = service.queryAttendanceMonth(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (AttendanceMonthVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(vos);


        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryOrgAttendanceMonth 组织考勤月度明细
     */
    @RequestMapping(value = "/queryOrgAttendanceMonth", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AttendanceMonthVO>> queryOrgAttendanceMonth(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgSequence","ASC");
        Long orgId = null;
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
             orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        /**
         *实现分页
         */
        Page<AttendanceMonthVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        if (orgId.equals(1502571152583692289L)){//选择的是集团
            param.getParams().remove("orgCode");
            param.getOrderMap().remove("orgSequence");

            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
            List<AttendanceMonthVO> vos = service.queryCompanyAttendanceMonth(page, wrapper);
            page.setRecords(vos);
        }else {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
            List<AttendanceMonthVO> vos = service.queryOrgAttendanceMonth(page, wrapper);
            page.setRecords(vos);
        }



        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryRecruitPostList 招聘岗位明细列表
     */
    @RequestMapping(value = "/queryRecruitPostList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RecruitPostVO>> queryRecruitPostList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("recruit_name");
        fuzzyFields.add("post_name");
        fuzzyFields.add("post_type");
        fuzzyFields.add("org_name");
        fuzzyFields.add("work_address");

        /**
         *实现分页
         */
        Page<RecruitPostVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<RecruitPostVO> vos = service.queryRecruitPostList(page, wrapper);
        page.setRecords(vos);
        return CommonResponse.success("查询招聘岗位明细列表成功！", page);

    }

    /**
     * @param param
     * @Description queryContractType 门户-合同分类
     */
    @RequestMapping(value = "/queryContractType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryContractType(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }

        /**
         *实现分页
         */
        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<TypeVO> vos = service.queryContractType(wrapper);
        page.setRecords(vos);
        return CommonResponse.success("查询招聘岗位明细列表成功！", page);

    }



    /**
     * @param param
     * @Description  考核明细
     */
    @RequestMapping(value = "/accessList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AccessVO>> accessList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("dw");
        fuzzyFields.add("bm");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");

        if(param.getParams().get("dwid") == null){
            /**
             * 组织隔离
             */
            boolean flag = false;
            //普通组织 id
            List<OrgVO> orgVOList = new ArrayList<>();
            List<String> orgCodes = new ArrayList<>();
            if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
                Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
                String orgType = "";
                if(param.getParams().get("orgType") != null){
                    orgType =param.getParams().get("orgType").getValue().toString();

                }if (!"5".equals(orgType)){//不是项目
                    flag = true;
                }
            } else {
                String orgType = InvocationInfoProxy.getOrgType();
                if (!"5".equals(orgType)){//不是项目
                    flag = true;
                }
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            orgVOList.stream().forEach(org -> {
                //普通组织
                orgCodes.add(org.getCode());
            });
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                if(flag) {
                    param.getParams().put("dwid", new Parameter(QueryParam.IN, orgCodes));
                }else {
                    param.getParams().put("bmid", new Parameter(QueryParam.IN, orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }

        }


        /**
         *实现分页
         */
        Page<AccessVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<AccessVO> projectEmployeeVOS = service.accessList(page, wrapper);

        for (AccessVO reportVO : projectEmployeeVOS) {
            try {
                String userCode = reportVO.getAid();
                //登录账号+,999912310000
                userCode = userCode + ",999912310000";
                //BASE64 GBK编码在URL GBK编码
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
       page.setRecords(projectEmployeeVOS);
        return CommonResponse.success("查询岗级职级！", page);

    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/accessListExport", method = RequestMethod.POST)
    @ResponseBody
    public void accessListExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("dw");
        fuzzyFields.add("bm");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");

        if(param.getParams().get("dwid") == null){
            /**
             * 组织隔离
             */
            boolean flag = false;
            //普通组织 id
            List<OrgVO> orgVOList = new ArrayList<>();
            List<String> orgCodes = new ArrayList<>();
            if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
                Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
                String orgType = "";
                if(param.getParams().get("orgType") != null){
                    orgType =param.getParams().get("orgType").getValue().toString();

                }if (!"5".equals(orgType)){//不是项目
                    flag = true;
                }
            } else {
                String orgType = InvocationInfoProxy.getOrgType();
                if (!"5".equals(orgType)){//不是项目
                    flag = true;
                }
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            orgVOList.stream().forEach(org -> {
                //普通组织
                orgCodes.add(org.getCode());
            });
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                if(flag) {
                    param.getParams().put("dwid", new Parameter(QueryParam.IN, orgCodes));
                }else {
                    param.getParams().put("bmid", new Parameter(QueryParam.IN, orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }

        }

        Map<String, Object> beans = new HashMap<>();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        Page<AccessVO> page = new Page<>(1, 1000);
        List<AccessVO> list = service.accessList(page, wrapper);
        if(list.size()> 1000){
            throw new BusinessException("导出数据过多，请筛选后多次导出结果！");
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("accessListExport.xlsx", beans, response);
    }


    /**
     * @param param
     * @Description  人事移动信息台账
     */
    @RequestMapping(value = "/queryUserChangeReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserChangeVO>> queryUserChangeReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");

        /**
         * 组织隔离
         */
        boolean flag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                flag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                flag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(flag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }

        /**
         *实现分页
         */
        Page<UserChangeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<UserChangeVO> userDataVOS = service.queryUserChangeReport(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询人事移动信息台账成功" +
                "", page);

    }


    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryUserData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserDataVO>> queryUserData(@RequestBody QueryParam param) {

       Long userid = InvocationInfoProxy.getUserid();
        CommonResponse<EmployeeVO> employeeVOCommonResponse = employeeApi.queryEmployeByUserId(userid);
        if (employeeVOCommonResponse.isSuccess()) {
            EmployeeVO data = employeeVOCommonResponse.getData();
            param.getParams().put("employee_code", new Parameter(QueryParam.EQ, data.getCode()));

            param.getParams().put("name", new Parameter(QueryParam.EQ, data.getName()));

            Page<UserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


            List<UserDataVO> userDataVOS = service.queryUserData(page, wrapper);

            /**
             * url etoken生成并放入VO返回
             */
            for (UserDataVO reportVO : userDataVOS) {
                //通过建造师编号查询员工信息
                CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
                if (userVO != null) {
                    try {
                        UserVO userVOData = userVO.getData();
                        if (userVOData != null) {
                            String userCode = userVOData.getUserCode();
                            //登录账号+,999912310000
                            userCode = userCode + ",999912310000";
                            //BASE64 GBK编码在URL GBK编码
                            String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                            String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                            //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                            reportVO.setUrl(url);
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            }

            page.setRecords(userDataVOS);
            return CommonResponse.success("查询列表数据成功！", page);
        }
        return CommonResponse.error("获取人员信息失败！");
    }

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息根据userCode
     */
    @RequestMapping(value = "/queryUserDataByUserCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserDataVO> queryUserDataByUserCode(@RequestParam String userCode) {
        QueryParam param = new QueryParam();
        param.getParams().put("employee_code", new Parameter(QueryParam.EQ,userCode));

            Page<UserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


            List<UserDataVO> userDataVOS = service.queryUserData(page, wrapper);

            if (CollectionUtils.isNotEmpty(userDataVOS)) {
                return CommonResponse.success("查询列表数据成功！", userDataVOS.get(0));
            }
        return CommonResponse.success("查询列表数据失败！");
    }

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/api/queryAllUserData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UserDataVO>> queryAllUserDataApi(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("sourceTypeSequence", "asc");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
//        service.queryHrOrgData("1");
//        /**
//         * 组织隔离
//         */
//        //普通组织 id
//        List<OrgVO> orgVOList = new ArrayList<>();
//        List<String> orgCodes = new ArrayList<>();
//        if (!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getCode());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            if(param.getParams().containsKey("orgType")){
                String orgType = param.getParams().get("orgType").getValue().toString();
                if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        if(param.getParams().containsKey("ignore")){
            param.getParams().remove("ignore");
            List<OrgVO> ignoreOrgVOList =  (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(ignoreOrgIds), true,"查询过滤掉组织失败，获取当前本下组织信息失败。");
            List<String> ignoreOrgCodes = new ArrayList<>();
            ignoreOrgVOList.stream().forEach(org -> {
                //普通组织
                ignoreOrgCodes.add(org.getCode());
            });
            orgVOList = orgVOList.stream().filter(s-> !ignoreOrgCodes.contains(s.getCode())).collect(Collectors.toList());
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }

        if (param.getParams().containsKey("workYear")) {
            String flag = param.getParams().get("workYear").getValue().toString();
            param.getParams().remove("workYear");
            if ("1".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year <= 1"));
            } else if ("2".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 1 + " and work_year <=" + 3));
            } else if ("3".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 3 + " and work_year <=" + 5));
            } else if ("4".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 5 + " and work_year <=" + 10));
            } else if ("5".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 10 + " and work_year <=" + 15));
            } else if ("6".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 15));
            }
        }
        if (param.getParams().containsKey("age")) {
            String flag = param.getParams().get("age").getValue().toString();

            param.getParams().remove("age");
            if ("1".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age <= 25"));
            } else if ("2".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 25 + " and age <=" + 35));
            } else if ("3".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 35 + " and age <=" + 45));
            } else if ("4".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 45 + " and age <=" + 55));
            } else if ("5".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 55));
            }
        }
        if (param.getParams().containsKey("title")) {
            String flag = param.getParams().get("title").getValue().toString();

            if ("0".equals(flag)) {
                param.getParams().remove("title");
                param.getParams().put("title", new Parameter(QueryParam.SQL, "title is null or title = ''"));
            }
        }
        if (param.getParams().containsKey("educationName")) {
            String flag = param.getParams().get("educationName").getValue().toString();

            if ("无".equals(flag)) {
                param.getParams().remove("educationName");
                param.getParams().put("educationName", new Parameter(QueryParam.SQL, "education_name is null or education_name = '' or education_id = 99 "));
            }
        }

        if (param.getParams().containsKey("departmentName")) {
            String flag = param.getParams().get("departmentName").getValue().toString();

            if (("待岗人员".equals(flag) && "ne".equals(param.getParams().get("departmentName").getType())) || "非待岗人员".equals(flag)) {
                param.getParams().remove("departmentName");
                param.getParams().put("departmentName", new Parameter(QueryParam.SQL, "(department_name is null or department_name != '待岗人员') "));
            }
        }
        /**
         * 岗级
         */
        if (param.getParams().containsKey("jobLevelCode")) {
            if (param.getParams().get("jobLevelCode").getValue().toString().equals("0")) {
                param.getParams().remove("jobLevelCode");
                param.getParams().put("jobLevelCode",new Parameter(QueryParam.SQL, "job_level_code is null")
                );
            }
        }
        if (param.getParams().containsKey("postCodeNew")) {
            if (param.getParams().get("postCodeNew").getValue().toString().equals("postCodeOther")) {
                param.getParams().remove("postCodeNew");
                param.getParams().put("postCodeNew",new Parameter(QueryParam.SQL, "(post_code_new is null or post_code_new = '')")
                );
            }
        }
        /**
         *实现分页
         */
        Page<UserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<UserDataVO> userDataVOS = service.queryAllUserData(page, wrapper);
        return CommonResponse.success("查询列表数据成功！", userDataVOS);
    }

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/api/queryAllUserSalary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SalaryUserDataVO>> queryAllUserSalary(@RequestBody QueryParam param) {

        List<SalaryUserDataVO> userDataVOS = service.queryAllUserSalary();
        return CommonResponse.success("查询列表数据成功！", userDataVOS);
    }

    /**
     * @param param
     * @Description 薪资系统-兼职信息同步
     */
    @RequestMapping(value = "/api/queryAllJobSalary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SalaryJobDataVO>> queryAllJobSalary(@RequestBody QueryParam param) {

        List<SalaryJobDataVO> userDataVOS = service.queryAllJobSalary();
        return CommonResponse.success("查询列表数据成功！", userDataVOS);
    }

    /**
     * @param param
     * @Description 薪资系统-考勤信息同步
     */
    @RequestMapping(value = "/api/queryAllAttendanceSalary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SalaryAttendanceDataVO>> queryAllAttendanceSalary(@RequestBody QueryParam param) {

        List<SalaryAttendanceDataVO> userDataVOS = service.queryAllAttendanceSalary();
        return CommonResponse.success("查询列表数据成功！", userDataVOS);
    }

    /**
     * @param param
     * @Description 薪资系统-异动信息同步
     */
    @RequestMapping(value = "/api/queryAllTransferSalary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SalaryTransferDataVO>> queryAllTransferSalary(@RequestBody QueryParam param) {

        List<SalaryTransferDataVO> userDataVOS = service.queryAllTransferSalary();
        return CommonResponse.success("查询列表数据成功！", userDataVOS);
    }


    /**
     * @param param
     * @Description  项目任职人员查询
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("departmentName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /**
         * 组织隔离
         */
        boolean flag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            String orgType = "";
            if(param.getParams().get("orgType") != null){
                orgType =param.getParams().get("orgType").getValue().toString();

            }if (!"5".equals(orgType)){//不是项目
                flag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                flag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            if(flag) {
                param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            }else {
                param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryParam deepCopyParam = Utils.deepCopy(param);
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("sourceType", "desc");
        param.getOrderMap().put("employeeSequence", "asc");
        /**
         *实现分页
         */
        Page<ProjectEmployeeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<ProjectEmployeeVO> projectEmployeeVOS = service.queryEmployeeReport(page, wrapper);

        logger.info("任职表遍历结束，时间：{}", System.currentTimeMillis());

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", projectEmployeeVOS);
        ExcelExport.getInstance().export("userReport.xlsx", beans, response);

    }
}
