/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.api.IShareCategoryApi;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.AccessVO;
import com.ejianc.business.hr.vo.AttendanceMonthVO;
import com.ejianc.business.hr.vo.JobLevelVO;
import com.ejianc.business.hr.vo.ProjectEmployeeVO;
import com.ejianc.business.hr.vo.RecruitPostVO;
import com.ejianc.business.hr.vo.RegisterTypeDataVO;
import com.ejianc.business.hr.vo.ResidencyUserDataVO;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UserChangeVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryAttendanceDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryJobDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryTransferDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryUserDataVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"baseUser"})
public class BaseUserController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBaseUserService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCategoryApi shareCategoryApi;
    public static List<Long> ignoreOrgIds = Arrays.asList(1502571153791651841L, 1502571153867149313L, 1502571153946841090L, 1502571154018144258L, 1502571154072670209L, 1502571154123001857L, 1502571154173333505L, 1502571154223665153L, 1502571154273996802L, 1502571154383048706L, 1502571154433380353L, 1502571154655678465L, 1502571154714398722L, 1502571154785701889L, 1502571154831839233L, 1502571154890559490L, 1502571155016388610L, 1502571155255463937L, 1502571156329205762L, 1502571158292140033L, 1502571158329888770L, 1502571158547992578L, 1502571158589935618L, 1502571158661238786L, 1633860192344920066L, 1687493596574613506L, 1777728175354720258L);

    @RequestMapping(value={"/queryAllUserData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserDataVO>> queryAllUserData(@RequestBody QueryParam param) {
        String flag;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("sourceTypeSequence", "asc");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        boolean orgTypeFlag = false;
        List<Object> orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            String orgType;
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            if (param.getParams().containsKey("orgType") && !"5".equals(orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString())) {
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)) {
                orgTypeFlag = true;
            }
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        if (param.getParams().containsKey("ignore")) {
            param.getParams().remove("ignore");
            List ignoreOrgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(ignoreOrgIds), true, "\u67e5\u8be2\u8fc7\u6ee4\u6389\u7ec4\u7ec7\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList ignoreOrgCodes = new ArrayList();
            ignoreOrgVOList.stream().forEach(org -> ignoreOrgCodes.add(org.getCode()));
            orgVOList = orgVOList.stream().filter(s -> !ignoreOrgCodes.contains(s.getCode())).collect(Collectors.toList());
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            if (orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter("in", orgCodes));
            } else {
                param.getParams().put("departmentCode", new Parameter("in", orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        if (param.getParams().containsKey("workYear")) {
            flag = ((Parameter)param.getParams().get("workYear")).getValue().toString();
            param.getParams().remove("workYear");
            if ("0".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year = 0"));
            } else if ("1".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year <= 1"));
            } else if ("2".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 1 and work_year <=3"));
            } else if ("3".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 3 and work_year <=5"));
            } else if ("4".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 5 and work_year <=10"));
            } else if ("5".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 10 and work_year <=15"));
            } else if ("6".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 15"));
            }
        }
        if (param.getParams().containsKey("age")) {
            flag = ((Parameter)param.getParams().get("age")).getValue().toString();
            param.getParams().remove("age");
            if ("1".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age <= 25"));
            } else if ("2".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 25 and age <=35"));
            } else if ("3".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 35 and age <=45"));
            } else if ("4".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 45 and age <=55"));
            } else if ("5".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 55"));
            }
        }
        if (param.getParams().containsKey("title") && "0".equals(flag = ((Parameter)param.getParams().get("title")).getValue().toString())) {
            param.getParams().remove("title");
            param.getParams().put("title", new Parameter("sql", (Object)"title is null or title = ''"));
        }
        if (param.getParams().containsKey("educationName") && "\u65e0".equals(flag = ((Parameter)param.getParams().get("educationName")).getValue().toString())) {
            param.getParams().remove("educationName");
            param.getParams().put("educationName", new Parameter("sql", (Object)"education_name is null or education_name = '' or education_id = 99 "));
        }
        if (param.getParams().containsKey("departmentName") && ("\u5f85\u5c97\u4eba\u5458".equals(flag = ((Parameter)param.getParams().get("departmentName")).getValue().toString()) && "ne".equals(((Parameter)param.getParams().get("departmentName")).getType()) || "\u975e\u5f85\u5c97\u4eba\u5458".equals(flag))) {
            param.getParams().remove("departmentName");
            param.getParams().put("departmentName", new Parameter("sql", (Object)"(department_name is null or department_name != '\u5f85\u5c97\u4eba\u5458') "));
        }
        if (param.getParams().containsKey("jobLevelCode") && ((Parameter)param.getParams().get("jobLevelCode")).getValue().toString().equals("0")) {
            param.getParams().remove("jobLevelCode");
            param.getParams().put("jobLevelCode", new Parameter("sql", (Object)"job_level_code is null"));
        }
        if (param.getParams().containsKey("postCodeNew") && ((Parameter)param.getParams().get("postCodeNew")).getValue().toString().equals("postCodeOther")) {
            param.getParams().remove("postCodeNew");
            param.getParams().put("postCodeNew", new Parameter("sql", (Object)"(post_code_new is null or post_code_new = '')"));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<UserDataVO> userDataVOS = this.service.queryAllUserData((Page<UserDataVO>)page, wrapper);
        for (UserDataVO reportVO : userDataVOS) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(userDataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryRegisterReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RegisterTypeDataVO>> queryRegisterReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("sourceTypeSequence", "asc");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        boolean orgTypeFlag = false;
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            String orgType = "";
            if (param.getParams().get("orgType") != null) {
                orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
            }
            if (!"5".equals(orgType)) {
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)) {
                orgTypeFlag = true;
            }
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            if (orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter("in", orgCodes));
            } else {
                param.getParams().put("departmentCode", new Parameter("in", orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<RegisterTypeDataVO> vos = this.service.queryRegisterReport((Page<RegisterTypeDataVO>)page, wrapper);
        for (RegisterTypeDataVO reportVO : vos) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryResidencyUserData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryResidencyUserData(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        if (param.getParams().get("orgName") != null && "null".equals(((Parameter)param.getParams().get("orgName")).getValue().toString())) {
            param.getParams().put("orgName", new Parameter("eq", null));
        }
        if (param.getParams().get("departmentName") != null && "null".equals(((Parameter)param.getParams().get("departmentName")).getValue().toString())) {
            param.getParams().put("departmentName", new Parameter("eq", null));
        }
        Object orgVOList = null;
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ResidencyUserDataVO> vos = this.service.queryResidencyUserData((Page<ResidencyUserDataVO>)page, wrapper);
        for (ResidencyUserDataVO reportVO : vos) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryUserChangeData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryUserChangeData(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("h.A0101");
        fuzzyFields.add("a.A0100");
        fuzzyFields.add("a.dw");
        fuzzyFields.add("a.gw");
        fuzzyFields.add("c.codeitemdesc");
        param.getParams().put("postName", new Parameter("like", (Object)"\u4eba\u4e8b"));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ResidencyUserDataVO> vos = this.service.queryUserChangeData((Page<ResidencyUserDataVO>)page, wrapper);
        for (ResidencyUserDataVO reportVO : vos) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryOrgType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryOrgType(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getOrderMap().put("typeCode", "asc");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryOrgType((Page<TypeVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryUserType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryUserType(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryUserType((Page<TypeVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryJobLevelReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JobLevelVO>> queryJobLevelReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("post_name");
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            param.getParams().put("a.b0110", new Parameter("in", orgCodes));
            param.getParams().remove("orgId");
        }
        param.getParams().put("a.a0198", new Parameter("not_in", Arrays.asList("E", "G", "H", "J", "K")));
        Page page = new Page((long)param.getPageIndex(), param.getPageSize() == 10 ? 50L : (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<Object> jobLevelVOS = this.service.queryJobLevelReport((Page<JobLevelVO>)page, wrapper);
        jobLevelVOS = jobLevelVOS.stream().sorted(Comparator.comparing(JobLevelVO::getJobLevelCode).reversed()).collect(Collectors.toList());
        page.setRecords(jobLevelVOS);
        page.setTotal((long)jobLevelVOS.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u5c97\u7ea7\u804c\u7ea7\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/queryEmployeeReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryEmployeeReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("departmentName");
        boolean flag = false;
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            String orgType = "";
            if (param.getParams().get("orgType") != null) {
                orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
            }
            if (!"5".equals(orgType)) {
                flag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)) {
                flag = true;
            }
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            if (flag) {
                param.getParams().put("orgCode", new Parameter("in", orgCodes));
            } else {
                param.getParams().put("departmentCode", new Parameter("in", orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryParam deepCopyParam = (QueryParam)Utils.deepCopy((Object)param);
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("sourceType", "desc");
        param.getOrderMap().put("employeeSequence", "asc");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProjectEmployeeVO> projectEmployeeVOS = this.service.queryEmployeeReport((Page<ProjectEmployeeVO>)page, wrapper);
        this.logger.info("\u4efb\u804c\u8868\u5f00\u59cb\u904d\u5386\uff0c\u65f6\u95f4\uff1a{}", (Object)System.currentTimeMillis());
        for (ProjectEmployeeVO reportVO : projectEmployeeVOS) {
            try {
                String userCode = reportVO.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CommonResponse booleanCommonResponse = null;
            booleanCommonResponse = "\u4e3b\u804c".equals(reportVO.getSourceType()) ? this.shareCategoryApi.queryUserSyncState(Integer.valueOf(1), reportVO.getCard(), reportVO.getOrgCode(), reportVO.getDepartmentCode(), reportVO.getPostId(), null) : this.shareCategoryApi.queryUserSyncState(Integer.valueOf(0), reportVO.getCard(), reportVO.getOrgCode(), reportVO.getDepartmentCode(), reportVO.getPostId(), null);
            if (booleanCommonResponse.isSuccess() && ((Boolean)booleanCommonResponse.getData()).booleanValue()) {
                reportVO.setIsSync("\u662f");
                continue;
            }
            reportVO.setIsSync("\u5426");
        }
        this.logger.info("\u4efb\u804c\u8868\u904d\u5386\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}", (Object)System.currentTimeMillis());
        page.setRecords(projectEmployeeVOS);
        QueryWrapper wrapper2 = BaseServiceImpl.changeToQueryWrapper((QueryParam)deepCopyParam);
        wrapper2.groupBy(new Object[]{"employee_code"});
        Page page1 = new Page(1L, 1L);
        List<ProjectEmployeeVO> projectEmployeeVOS2 = this.service.queryEmployeeReportNum((Page<ProjectEmployeeVO>)page1, wrapper2, "employee_code");
        Long zrs = 0L;
        zrs = page1.getTotal();
        QueryWrapper objectQueryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)deepCopyParam);
        objectQueryWrapper.groupBy(new Object[]{"source_type"});
        Page page2 = new Page(-1L, 1000L);
        List<ProjectEmployeeVO> projectEmployeeVOS1 = this.service.queryEmployeeReportNum((Page<ProjectEmployeeVO>)page2, objectQueryWrapper, "source_type");
        Integer jz = 0;
        Integer zz = 0;
        if (CollectionUtils.isNotEmpty(projectEmployeeVOS1)) {
            for (ProjectEmployeeVO projectEmployeeVO : projectEmployeeVOS1) {
                if ("\u517c\u804c".equals(projectEmployeeVO.getSourceType())) {
                    jz = projectEmployeeVO.getNum();
                    continue;
                }
                zz = projectEmployeeVO.getNum();
            }
        }
        JSONObject pageData = new JSONObject();
        pageData.put("records", (Object)page.getRecords());
        pageData.put("total", (Object)page.getTotal());
        pageData.put("current", (Object)page.getCurrent());
        pageData.put("size", (Object)page.getSize());
        pageData.put("pages", (Object)page.getPages());
        pageData.put("jz", (Object)jz);
        pageData.put("zz", (Object)zz);
        pageData.put("zrs", (Object)zrs);
        return CommonResponse.success((String)"\u67e5\u8be2\u5c97\u7ea7\u804c\u7ea7\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAttendanceMonth"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AttendanceMonthVO>> queryAttendanceMonth(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgSequence", "ASC");
        param.getOrderMap().put("departmentSequence", "ASC");
        param.getOrderMap().put("sequence", "ASC");
        Long orgId = null;
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            param.getParams().put("orgCode", new Parameter("in", orgCodes));
            param.getParams().remove("orgId");
        }
        if (orgId.equals(1502571152583692289L)) {
            param.getParams().remove("orgCode");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AttendanceMonthVO> vos = this.service.queryAttendanceMonth((Page<AttendanceMonthVO>)page, wrapper);
        for (AttendanceMonthVO reportVO : vos) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryOrgAttendanceMonth"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AttendanceMonthVO>> queryOrgAttendanceMonth(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgSequence", "ASC");
        Long orgId = null;
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            param.getParams().put("orgCode", new Parameter("in", orgCodes));
            param.getParams().remove("orgId");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        if (orgId.equals(1502571152583692289L)) {
            param.getParams().remove("orgCode");
            param.getOrderMap().remove("orgSequence");
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<AttendanceMonthVO> vos = this.service.queryCompanyAttendanceMonth((Page<AttendanceMonthVO>)page, wrapper);
            page.setRecords(vos);
        } else {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<AttendanceMonthVO> vos = this.service.queryOrgAttendanceMonth((Page<AttendanceMonthVO>)page, wrapper);
            page.setRecords(vos);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryRecruitPostList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RecruitPostVO>> queryRecruitPostList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("recruit_name");
        fuzzyFields.add("post_name");
        fuzzyFields.add("post_type");
        fuzzyFields.add("org_name");
        fuzzyFields.add("work_address");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<RecruitPostVO> vos = this.service.queryRecruitPostList((Page<RecruitPostVO>)page, wrapper);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u62db\u8058\u5c97\u4f4d\u660e\u7ec6\u5217\u8868\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryContractType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryContractType(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        boolean orgTypeFlag = false;
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            String orgType = "";
            if (param.getParams().get("orgType") != null) {
                orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
            }
            if (!"5".equals(orgType)) {
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)) {
                orgTypeFlag = true;
            }
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            if (orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter("in", orgCodes));
            } else {
                param.getParams().put("departmentCode", new Parameter("in", orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<TypeVO> vos = this.service.queryContractType(wrapper);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u62db\u8058\u5c97\u4f4d\u660e\u7ec6\u5217\u8868\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/accessList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AccessVO>> accessList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("dw");
        fuzzyFields.add("bm");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        if (param.getParams().get("dwid") == null) {
            boolean flag = false;
            List orgVOList = new ArrayList();
            ArrayList orgCodes = new ArrayList();
            if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
                Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
                orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                String orgType = "";
                if (param.getParams().get("orgType") != null) {
                    orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
                }
                if (!"5".equals(orgType)) {
                    flag = true;
                }
            } else {
                String orgType = InvocationInfoProxy.getOrgType();
                if (!"5".equals(orgType)) {
                    flag = true;
                }
                orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            }
            orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                if (flag) {
                    param.getParams().put("dwid", new Parameter("in", orgCodes));
                } else {
                    param.getParams().put("bmid", new Parameter("in", orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AccessVO> projectEmployeeVOS = this.service.accessList((Page<AccessVO>)page, wrapper);
        for (AccessVO reportVO : projectEmployeeVOS) {
            try {
                String userCode = reportVO.getAid();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                reportVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(projectEmployeeVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5c97\u7ea7\u804c\u7ea7\uff01", (Object)page);
    }

    @RequestMapping(value={"/accessListExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void accessListExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("dw");
        fuzzyFields.add("bm");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        if (param.getParams().get("dwid") == null) {
            boolean flag = false;
            List orgVOList = new ArrayList();
            ArrayList orgCodes = new ArrayList();
            if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
                Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
                orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                String orgType = "";
                if (param.getParams().get("orgType") != null) {
                    orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
                }
                if (!"5".equals(orgType)) {
                    flag = true;
                }
            } else {
                String orgType = InvocationInfoProxy.getOrgType();
                if (!"5".equals(orgType)) {
                    flag = true;
                }
                orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            }
            orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                if (flag) {
                    param.getParams().put("dwid", new Parameter("in", orgCodes));
                } else {
                    param.getParams().put("bmid", new Parameter("in", orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }
        }
        HashMap<String, List<AccessVO>> beans = new HashMap<String, List<AccessVO>>();
        Page page = new Page(1L, 1000L);
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AccessVO> list = this.service.accessList((Page<AccessVO>)page, wrapper);
        if (list.size() > 1000) {
            throw new BusinessException("\u5bfc\u51fa\u6570\u636e\u8fc7\u591a\uff0c\u8bf7\u7b5b\u9009\u540e\u591a\u6b21\u5bfc\u51fa\u7ed3\u679c\uff01");
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("accessListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryUserChangeReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserChangeVO>> queryUserChangeReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        boolean flag = false;
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            String orgType = "";
            if (param.getParams().get("orgType") != null) {
                orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
            }
            if (!"5".equals(orgType)) {
                flag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)) {
                flag = true;
            }
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            if (flag) {
                param.getParams().put("orgCode", new Parameter("in", orgCodes));
            } else {
                param.getParams().put("departmentCode", new Parameter("in", orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<UserChangeVO> userDataVOS = this.service.queryUserChangeReport((Page<UserChangeVO>)page, wrapper);
        for (UserDataVO userDataVO : userDataVOS) {
            CommonResponse userVO = this.userApi.queryUserByUserCode(userDataVO.getUserCode());
            if (userVO == null) continue;
            try {
                UserVO userVOData = (UserVO)userVO.getData();
                if (userVOData == null) continue;
                String userCode = userVOData.getUserCode();
                userCode = userCode + ",999912310000";
                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                userDataVO.setUrl(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setRecords(userDataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u4e8b\u79fb\u52a8\u4fe1\u606f\u53f0\u8d26\u6210\u529f", (Object)page);
    }

    @RequestMapping(value={"/queryUserData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserDataVO>> queryUserData(@RequestBody QueryParam param) {
        Long userid = InvocationInfoProxy.getUserid();
        CommonResponse employeeVOCommonResponse = this.employeeApi.queryEmployeByUserId(userid);
        if (employeeVOCommonResponse.isSuccess()) {
            EmployeeVO data = (EmployeeVO)employeeVOCommonResponse.getData();
            param.getParams().put("employee_code", new Parameter("eq", (Object)data.getCode()));
            param.getParams().put("name", new Parameter("eq", (Object)data.getName()));
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<UserDataVO> userDataVOS = this.service.queryUserData((Page<UserDataVO>)page, wrapper);
            for (UserDataVO reportVO : userDataVOS) {
                CommonResponse userVO = this.userApi.queryUserByUserCode(reportVO.getUserCode());
                if (userVO == null) continue;
                try {
                    UserVO userVOData = (UserVO)userVO.getData();
                    if (userVOData == null) continue;
                    String userCode = userVOData.getUserCode();
                    userCode = userCode + ",999912310000";
                    String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                    String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                    reportVO.setUrl(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            page.setRecords(userDataVOS);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
        }
        return CommonResponse.error((String)"\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/queryUserDataByUserCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UserDataVO> queryUserDataByUserCode(@RequestParam String userCode) {
        QueryParam param = new QueryParam();
        param.getParams().put("employee_code", new Parameter("eq", (Object)userCode));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<UserDataVO> userDataVOS = this.service.queryUserData((Page<UserDataVO>)page, wrapper);
        if (CollectionUtils.isNotEmpty(userDataVOS)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)userDataVOS.get(0));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/api/queryAllUserData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<UserDataVO>> queryAllUserDataApi(@RequestBody QueryParam param) {
        String flag;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("sourceTypeSequence", "asc");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        boolean orgTypeFlag = false;
        List<Object> orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            String orgType;
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            if (param.getParams().containsKey("orgType") && !"5".equals(orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString())) {
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)) {
                orgTypeFlag = true;
            }
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        if (param.getParams().containsKey("ignore")) {
            param.getParams().remove("ignore");
            List ignoreOrgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(ignoreOrgIds), true, "\u67e5\u8be2\u8fc7\u6ee4\u6389\u7ec4\u7ec7\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList ignoreOrgCodes = new ArrayList();
            ignoreOrgVOList.stream().forEach(org -> ignoreOrgCodes.add(org.getCode()));
            orgVOList = orgVOList.stream().filter(s -> !ignoreOrgCodes.contains(s.getCode())).collect(Collectors.toList());
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            if (orgTypeFlag) {
                param.getParams().put("orgCode", new Parameter("in", orgCodes));
            } else {
                param.getParams().put("departmentCode", new Parameter("in", orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        if (param.getParams().containsKey("workYear")) {
            flag = ((Parameter)param.getParams().get("workYear")).getValue().toString();
            param.getParams().remove("workYear");
            if ("1".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year <= 1"));
            } else if ("2".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 1 and work_year <=3"));
            } else if ("3".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 3 and work_year <=5"));
            } else if ("4".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 5 and work_year <=10"));
            } else if ("5".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 10 and work_year <=15"));
            } else if ("6".equals(flag)) {
                param.getParams().put("workYear", new Parameter("sql", (Object)"work_year > 15"));
            }
        }
        if (param.getParams().containsKey("age")) {
            flag = ((Parameter)param.getParams().get("age")).getValue().toString();
            param.getParams().remove("age");
            if ("1".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age <= 25"));
            } else if ("2".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 25 and age <=35"));
            } else if ("3".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 35 and age <=45"));
            } else if ("4".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 45 and age <=55"));
            } else if ("5".equals(flag)) {
                param.getParams().put("age", new Parameter("sql", (Object)"age > 55"));
            }
        }
        if (param.getParams().containsKey("title") && "0".equals(flag = ((Parameter)param.getParams().get("title")).getValue().toString())) {
            param.getParams().remove("title");
            param.getParams().put("title", new Parameter("sql", (Object)"title is null or title = ''"));
        }
        if (param.getParams().containsKey("educationName") && "\u65e0".equals(flag = ((Parameter)param.getParams().get("educationName")).getValue().toString())) {
            param.getParams().remove("educationName");
            param.getParams().put("educationName", new Parameter("sql", (Object)"education_name is null or education_name = '' or education_id = 99 "));
        }
        if (param.getParams().containsKey("departmentName") && ("\u5f85\u5c97\u4eba\u5458".equals(flag = ((Parameter)param.getParams().get("departmentName")).getValue().toString()) && "ne".equals(((Parameter)param.getParams().get("departmentName")).getType()) || "\u975e\u5f85\u5c97\u4eba\u5458".equals(flag))) {
            param.getParams().remove("departmentName");
            param.getParams().put("departmentName", new Parameter("sql", (Object)"(department_name is null or department_name != '\u5f85\u5c97\u4eba\u5458') "));
        }
        if (param.getParams().containsKey("jobLevelCode") && ((Parameter)param.getParams().get("jobLevelCode")).getValue().toString().equals("0")) {
            param.getParams().remove("jobLevelCode");
            param.getParams().put("jobLevelCode", new Parameter("sql", (Object)"job_level_code is null"));
        }
        if (param.getParams().containsKey("postCodeNew") && ((Parameter)param.getParams().get("postCodeNew")).getValue().toString().equals("postCodeOther")) {
            param.getParams().remove("postCodeNew");
            param.getParams().put("postCodeNew", new Parameter("sql", (Object)"(post_code_new is null or post_code_new = '')"));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<UserDataVO> userDataVOS = this.service.queryAllUserData((Page<UserDataVO>)page, wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", userDataVOS);
    }

    @RequestMapping(value={"/api/queryAllUserSalary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SalaryUserDataVO>> queryAllUserSalary(@RequestBody QueryParam param) {
        List<SalaryUserDataVO> userDataVOS = this.service.queryAllUserSalary();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", userDataVOS);
    }

    @RequestMapping(value={"/api/queryAllJobSalary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SalaryJobDataVO>> queryAllJobSalary(@RequestBody QueryParam param) {
        List<SalaryJobDataVO> userDataVOS = this.service.queryAllJobSalary();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", userDataVOS);
    }

    @RequestMapping(value={"/api/queryAllAttendanceSalary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SalaryAttendanceDataVO>> queryAllAttendanceSalary(@RequestBody QueryParam param) {
        List<SalaryAttendanceDataVO> userDataVOS = this.service.queryAllAttendanceSalary();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", userDataVOS);
    }

    @RequestMapping(value={"/api/queryAllTransferSalary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SalaryTransferDataVO>> queryAllTransferSalary(@RequestBody QueryParam param) {
        List<SalaryTransferDataVO> userDataVOS = this.service.queryAllTransferSalary();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", userDataVOS);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("departmentName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        boolean flag = false;
        List orgVOList = new ArrayList();
        ArrayList orgCodes = new ArrayList();
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            String orgType = "";
            if (param.getParams().get("orgType") != null) {
                orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
            }
            if (!"5".equals(orgType)) {
                flag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)) {
                flag = true;
            }
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgCodes.add(org.getCode()));
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            if (flag) {
                param.getParams().put("orgCode", new Parameter("in", orgCodes));
            } else {
                param.getParams().put("departmentCode", new Parameter("in", orgCodes));
            }
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        }
        QueryParam deepCopyParam = (QueryParam)Utils.deepCopy((Object)param);
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("sourceType", "desc");
        param.getOrderMap().put("employeeSequence", "asc");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProjectEmployeeVO> projectEmployeeVOS = this.service.queryEmployeeReport((Page<ProjectEmployeeVO>)page, wrapper);
        this.logger.info("\u4efb\u804c\u8868\u904d\u5386\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}", (Object)System.currentTimeMillis());
        HashMap<String, List<ProjectEmployeeVO>> beans = new HashMap<String, List<ProjectEmployeeVO>>();
        beans.put("records", projectEmployeeVOS);
        ExcelExport.getInstance().export("userReport.xlsx", beans, response);
    }
}

