package com.ejianc.business.hr.service.impl;

import com.ejianc.business.hr.bean.BaseOrgEntity;
import com.ejianc.business.hr.mapper.BaseOrgMapper;
import com.ejianc.business.hr.mapper.UserChangeMapper;
import com.ejianc.business.hr.service.IBaseOrgService;
import com.ejianc.business.hr.service.IUserChangeService;
import com.ejianc.business.hr.vo.OrgDataVO;
import com.ejianc.business.hrm.vo.UserChangeVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Service("hrUserChangeService")
public class UserChangeServiceImpl extends BaseServiceImpl<UserChangeMapper, BaseOrgEntity> implements IUserChangeService {

    @Autowired
    private UserChangeMapper mapper;


    @Override
    public String userChangeEffect(UserChangeVO vo) {
        /**
         * 1.保存修改ABE
         */

        //获取最大的I9999
        String maxI9999 = mapper.getMaxI9999("UsrABE","A0100",vo.getUserCode());
        //修改异动结束时间为空的上一条数据
        int i = mapper.updateAbeEndTime(vo.getChangeTime(), vo.getUserCode());
        //增加一条新的异动信息
//        getChangeTime 增加一天
        Calendar cal = Calendar.getInstance();
        cal.setTime(vo.getChangeTime());
        cal.add(Calendar.DATE, 1); //

        vo.setChangeTime(cal.getTime());
        //拼接单位+部门 赋值单位
        vo.setNewOrgName(vo.getNewOrgName()+vo.getNewDeptName());
        vo.setOldOrgName(vo.getOldOrgName()+vo.getOldDeptName());
        int j = mapper.insertAbe(vo,maxI9999);

        /**
         * 2.保存修改A09
         */


        /**
         * 3.保存修改A01
         */
        return "";
    }
}
