package com.ejianc.business.hr.controller;


import com.ejianc.business.hr.service.IUserChangeService;
import com.ejianc.business.hrm.vo.UserChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Controller
@RequestMapping("hrUserChange/")
public class UserChangeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserChangeService service;


    /**
     * 人员异动-生效
     * @param vo
     * @return
     */
    @RequestMapping(value = "effect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> userChangeEffect(@RequestBody UserChangeVO vo){
        String s = service.userChangeEffect(vo);
        return CommonResponse.success("保存或修改单据成功！",s);
    }

}
