package com.ejianc.foundation.workbench.vo;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.framework.skeleton.template.BaseTreeVO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 菜单
 *
 * @author guominga
 * 
 * @date 2019年4月3日
 */
public class MenuItemVO extends BaseTreeVO<MenuItemVO> {

	private static final long serialVersionUID = 1L;

	/**
	 * 菜单类型：虚拟菜单
	 */
	public static final Integer MENU_TYPE_VIRTUAL = 1;

	/**
	 * 菜单类型：菜单
	 */
	public static final Integer MENU_TYPE_MENU = 0;

	private Long menuCategoryId; // 菜单分类id

	private String code;

	/**
	 * 菜单名称
	 */
	private String name;

	/**
	 * 菜单图标
	 */
	private String icon;

	/**
	 * 是否虚拟菜单（0：不是 ，1：是）
	 */
	private Integer virtualFlag;

	/**
	 * 是否移动菜单（0：不是 ，1：是）
	 */
	private Integer mobile;

	/**
	 * 功能Id
	 */
	private Long appId;

	/**
	 * 父ID
	 */
	private Long parentId;

	/**
	 * 排序号
	 */
	private Integer sequence;

	private String type;// 来源（自定义，平台，同步修改）

	/**
	 * 是否含有下级节点
	 */
	private Boolean isLeaf;

	/**
	 * 菜单关联功能名称
	 */
	private String appName;

	/**
	 * 应用访问路径
	 */
	private String appPath;
	/**
	 * 系统ID
	 */
	private Long systemId;

	/**
	 * 应用新增页面路径，仅用于pc菜单使用
	 */
	private JSONArray appAddPath;

	private String openMode; // 应用打开方式

	private Integer collectFlag; // 是否已收藏

	private Map<String, Object> app = new HashMap<>();

	private Map<String, Object> parent;

	private Map<String, Object> system;

	private List<MenuItemVO> children = new ArrayList<MenuItemVO>();
	private Long customId;// 自定义id

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Boolean getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Boolean isLeaf) {
		this.isLeaf = isLeaf;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Boolean getLeaf() {
		return isLeaf;
	}

	public void setLeaf(Boolean leaf) {
		isLeaf = leaf;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public Map<String, Object> getParent() {
		return parent;
	}

	public void setParent(Map<String, Object> parent) {
		this.parent = parent;
	}

	public Map<String, Object> getApp() {
		app.put("id", this.getId());
		app.put("name", this.appName);
		return app;
	}

	public void setApp(Map<String, Object> app) {
		this.app = app;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getVirtualFlag() {
		return virtualFlag;
	}

	public void setVirtualFlag(Integer virtualFlag) {
		this.virtualFlag = virtualFlag;
	}

	public List<MenuItemVO> getChildren() {
		return children;
	}

	public void setChildren(List<MenuItemVO> children) {
		this.children = children;
	}

	public String getAppPath() {
		return appPath;
	}

	public void setAppPath(String appPath) {
		this.appPath = appPath;
	}

	public String getOpenMode() {
		return openMode;
	}

	public void setOpenMode(String openMode) {
		this.openMode = openMode;
	}

	public Integer getCollectFlag() {
		return collectFlag;
	}

	public void setCollectFlag(Integer collectFlag) {
		this.collectFlag = collectFlag;
	}

	public Integer getMobile() {
		return mobile;
	}

	public void setMobile(Integer mobile) {
		this.mobile = mobile;
	}

	public Long getCustomId() {
		return customId;
	}

	public void setCustomId(Long customId) {
		this.customId = customId;
	}

	public JSONArray getAppAddPath() {
		return appAddPath;
	}

	public void setAppAddPath(JSONArray appAddPath) {
		this.appAddPath = appAddPath;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Long getMenuCategoryId() {
		return menuCategoryId;
	}

	public void setMenuCategoryId(Long menuCategoryId) {
		this.menuCategoryId = menuCategoryId;
	}

	public Long getSystemId() {
		return systemId;
	}

	public void setSystemId(Long systemId) {
		this.systemId = systemId;
	}

	public Map<String, Object> getSystem() {
		return system;
	}

	public void setSystem(Map<String, Object> system) {
		this.system = system;
	}
}
