package com.ejianc.foundation.orgcenter.vo;

import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 部门bean
 * 
 * @author guominga
 */
public class DeptVO extends BaseVO {

	public static final Integer DEPT_TYPE_VIRTUAL = 2;
	public static final Integer DEPT_TYPE_NORMAL = 1;

	private static final long serialVersionUID = 1L;

	private Long orgId;// 公司Id

	private String code;// 部门编号

	private String name;// 部门名称

	private String shortName;// 部门简称

	private String manager;// 负责人
	
	private Long deptHead;// 部门负责人

	private String phone; // 负责人电话

	private String note; // 部门描述

	private Integer state; // 1：启用 ， 0：停用

	private Integer sequence; // 排序号

	private String sourceId; // 来源id

	private String systemId; // 系统id

	private String sourceOrgId; // 来源组织id(同步数据使用）
	
	/**
	 * 部门类型：1、普通部门, 2-虚拟部门
	 */
	private Integer type;

	private Long pid;// 上级部门idId

	private Long jid;// 负责人的jobId

	private Boolean isLeaf;	//是否叶子节点

	private List<DeptVO> children;

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getManager() {
		return manager;
	}

	public void setManager(String manager) {
		this.manager = manager;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getSourceOrgId() {
		return sourceOrgId;
	}

	public void setSourceOrgId(String sourceOrgId) {
		this.sourceOrgId = sourceOrgId;
	}

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	public List<DeptVO> getChildren() {
		return children;
	}

	public void setChildren(List<DeptVO> children) {
		this.children = children;
	}

	public Boolean getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Boolean isLeaf) {
		this.isLeaf = isLeaf;
	}

	public Long getJid() {
		return jid;
	}

	public void setJid(Long jid) {
		this.jid = jid;
	}

	@ReferSerialTransfer(referCode="idm-user")
	public Long getDeptHead() {
		return deptHead;
	}

    @ReferDeserialTransfer
	public void setDeptHead(Long deptHead) {
		this.deptHead = deptHead;
	}

}
