package com.ejianc.foundation.tenant.api;

import com.ejianc.foundation.tenant.hystrix.TenantHystrix;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/1/27 9:48
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = TenantHystrix.class)
public interface ITenantApi {


    /**
     * 查询所有有效的租户Id列表
     *
     * @return
     */
    @GetMapping(value = "/api/tenant/getAllValidTenantId")
    CommonResponse<List<Long>> getAllValidTenantId();

    /**
     * 查询租户详情
     *
     * @return
     */
    @GetMapping(value = "/no_auth/api/tenant/queryDetail")
    CommonResponse<TenantVO> queryDetail(@RequestParam("tenantId") Long tenantId);
    /**
     * 更细租户名称，包括企业名称，根组织名称，需要特定签名
     * */
    @GetMapping(value = "/api/tenant/updateTenantName")
    CommonResponse<String> updateTenantName(@RequestParam String tenantId, @RequestParam String tenantName, @RequestParam String sign);

}
