package com.ejianc.foundation.usercenter.api;

import com.ejianc.foundation.usercenter.hystrix.CooperateEnterpriseApiHystrix;
import com.ejianc.foundation.usercenter.vo.CooperateEnterpriseVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/6 11:57
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = CooperateEnterpriseApiHystrix.class)
public interface ICooperateEnterpriseApi {

    /**
     * 供方（公有云）使用，根据供方租户id查询该供方租户合作的施工方id（私有化企业）
     * @param supplierTenantId
     * @return
     */
    @GetMapping(value = "/api/cooperateEnterprise/getCooperateEnterpriseByTenantId")
    CommonResponse<List<String>> getCooperateEnterpriseByTenantId(@RequestParam(value = "supplierTenantId") Long supplierTenantId);

    /**
     * 供方（公有云）使用，根据供方租户id和合作的施工方id（私有化企业）查询该供方租户在施工方的供方id
     * @param supplierTenantId
     * @return
     */
    @GetMapping(value = "/api/cooperateEnterprise/getCooperateSupplierIdByTenantIdAndEnterpriseId")
    CommonResponse<Long> getCooperateSupplierIdByTenantIdAndEnterpriseId(@RequestParam(value = "supplierTenantId") Long supplierTenantId, @RequestParam(value = "systemId") String systemId);

    /**
     * 供方（公有云）使用，根据施工方id（私有化企业）查询该企业合作的供方租户的超级管理员用户id
     * @param systemId
     * Map<Long,List<Long>>  租户id----管理员id
     * @return
     */
    @GetMapping(value = "/api/cooperateEnterprise/getCooperateSupplierSuperUserIdByEnterpriseId")
    CommonResponse<Map<Long,List<Long>>> getCooperateSupplierSuperUserIdByEnterpriseId(@RequestParam(value = "systemId") String systemId);

    /**
     * 供方（公有云）使用，根据供方租户id列表查询这些租户对应的超级管理员用户id
     * Map<Long,List<Long>>  租户id----管理员id
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "/api/cooperateEnterprise/getSuperUserIdBySupplierTenantId")
    CommonResponse<Map<Long,List<Long>>> getSuperUserIdBySupplierTenantId(@RequestBody List<Long> tenantIds);

    /**
     * 租户引入供应商时候，生成供应商租户对应的供应商合作企业信息
     */
    @PostMapping(value = "/api/cooperateEnterprise/createCooperate")
    CommonResponse<String> createCooperate(@RequestBody List<CooperateEnterpriseVO> cooperateEnterpriseVOS);

}
