package com.ejianc.foundation.orgcenter.api;

import com.ejianc.foundation.orgcenter.hystrix.ReportHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name = "ejc-idm-web", url = "${common.env.feign-client-url}", path = "ejc-idm-web", fallback = ReportHystrix.class)
public interface IReportApi {
    /**
     * 收入合同报表，默认查询参数
     * 本下组织，当前租户
     *
     * @return
     */
    @RequestMapping(value = "/api/report/getIncomeQueryParam", method = RequestMethod.GET)
    CommonResponse<QueryParam> findChildrenByParentId();

    /**
     * 其他收入报表，默认查询参数
     *
     * @return
     */
    @RequestMapping(value = "/api/report/getOtherIncomeQueryParam", method = RequestMethod.GET)
    CommonResponse<QueryParam> getOtherIncomeQueryParam();

    /**
     * 支出合同报表，默认查询参数
     *
     * @return
     */
    @RequestMapping(value = "/api/report/getPayQueryParam", method = RequestMethod.GET)
    CommonResponse<QueryParam> getPayQueryParam();

    /**
     * 其他支出报表，默认查询参数
     *
     * @return
     */
    @RequestMapping(value = "/api/report/getOtherPayQueryParam", method = RequestMethod.GET)
    CommonResponse<QueryParam> getOtherPayQueryParam();
    /**
     * 项目报表，默认查询参数
     *
     * @return
     */
    @RequestMapping(value = "/api/report/getProjectQueryParam", method = RequestMethod.GET)
    CommonResponse<QueryParam> getProjectQueryParam();
    /**
     * 预算与实际成本对比报表，默认查询参数
     *
     * @return
     */
    @RequestMapping(value = "/api/report/getBudgetCostQueryParam", method = RequestMethod.GET)
    CommonResponse<QueryParam> getBudgetCostQueryParam();
}
